/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.control;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.control.ControlBase;
import org.kuali.rice.krad.uif.control.SizedControl;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.widget.DatePicker;

@BeanTags(value={@BeanTag(name="textControl", parent="Uif-TextControl"), @BeanTag(name="smallTextControl", parent="Uif-SmallTextControl"), @BeanTag(name="mediumTextControl", parent="Uif-MediumTextControl"), @BeanTag(name="largeTextControl", parent="Uif-LargeTextControl"), @BeanTag(name="currencyTextControl", parent="Uif-CurrencyTextControl"), @BeanTag(name="dateControl", parent="Uif-DateControl")})
public class TextControlBase
extends ControlBase
implements TextControl,
SizedControl {
    private static final long serialVersionUID = -8267606288443759880L;
    private int size;
    private Integer maxLength;
    private Integer minLength;
    private DatePicker datePicker;
    private String watermarkText = "";
    private boolean textExpand;

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (parent instanceof InputField) {
            InputField field = (InputField)parent;
            if (this.getMaxLength() == null) {
                this.setMaxLength(field.getMaxLength());
            }
            if (this.getMinLength() == null) {
                this.setMinLength(field.getMinLength());
            }
            if (this.textExpand || this.datePicker != null && this.datePicker.isRender()) {
                field.setRenderInputAddonGroup(true);
            }
        }
    }

    @Override
    @BeanTagAttribute
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    @BeanTagAttribute
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    @BeanTagAttribute
    public Integer getMinLength() {
        return this.minLength;
    }

    @Override
    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public DatePicker getDatePicker() {
        return this.datePicker;
    }

    @Override
    public void setDatePicker(DatePicker datePicker) {
        this.datePicker = datePicker;
    }

    @Override
    @BeanTagAttribute
    public boolean isTextExpand() {
        return this.textExpand;
    }

    @Override
    public void setTextExpand(boolean textExpand) {
        this.textExpand = textExpand;
    }

    @Override
    @BeanTagAttribute(name="watermarkText")
    public String getWatermarkText() {
        return this.watermarkText;
    }

    @Override
    public void setWatermarkText(String watermarkText) {
        if (StringUtils.isNotEmpty((String)watermarkText)) {
            watermarkText = (String)watermarkText + "   ";
        }
        this.watermarkText = watermarkText;
    }
}

