/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.state.StateMapping;
import org.kuali.rice.krad.datadictionary.validation.constraint.BaseConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;

public class ConstraintStateUtils {
    public static boolean constraintAppliesForState(String applicableState, Constraint constraint, StateMapping stateMapping) {
        List<Object> stateOrder = new ArrayList();
        if (stateMapping != null) {
            stateOrder = stateMapping.getStates();
        }
        if (stateMapping == null || !(constraint instanceof BaseConstraint) || StringUtils.isEmpty((String)applicableState)) {
            return true;
        }
        if (((BaseConstraint)constraint).getStates() == null || ((BaseConstraint)constraint).getStates().isEmpty()) {
            return true;
        }
        if (((BaseConstraint)constraint).getStates().contains(applicableState) && stateOrder.contains(applicableState)) {
            return true;
        }
        for (String constraintState : ((BaseConstraint)constraint).getStates()) {
            if (constraintState.contains(">")) {
                String[] rangeArray = constraintState.split(">");
                if (rangeArray[1].endsWith("+")) {
                    constraintState = rangeArray[1];
                    rangeArray[1] = StringUtils.removeEnd((String)rangeArray[1], (String)"+");
                }
                if (stateOrder.contains(rangeArray[0]) && stateOrder.contains(rangeArray[1])) {
                    for (int i = stateOrder.indexOf(rangeArray[0]); i <= stateOrder.indexOf(rangeArray[1]); ++i) {
                        if (!((String)stateOrder.get(i)).equals(applicableState)) continue;
                        return true;
                    }
                } else {
                    throw new RuntimeException("Invalid state range: " + constraintState);
                }
            }
            if (!constraintState.contains("+")) continue;
            if (stateOrder.contains(constraintState = StringUtils.removeEnd((String)constraintState, (String)"+"))) {
                for (int i = stateOrder.indexOf(constraintState); i < stateOrder.size(); ++i) {
                    if (!((String)stateOrder.get(i)).equals(applicableState)) continue;
                    return true;
                }
                continue;
            }
            throw new RuntimeException("Invalid constraint state: " + constraintState);
        }
        return false;
    }

    public static <T extends Constraint> T getApplicableConstraint(T constraint, String validationState, StateMapping stateMapping) {
        if (constraint != null && constraint instanceof BaseConstraint && stateMapping != null && StringUtils.isNotBlank((String)validationState)) {
            if (((BaseConstraint)constraint).getConstraintStateOverrides() != null && !((BaseConstraint)constraint).getConstraintStateOverrides().isEmpty()) {
                BaseConstraint override = null;
                BaseConstraint theConstraint = (BaseConstraint)constraint;
                for (BaseConstraint baseConstraint : theConstraint.getConstraintStateOverrides()) {
                    if (baseConstraint.getStates().isEmpty() || !ConstraintStateUtils.constraintAppliesForState(validationState, baseConstraint, stateMapping)) continue;
                    try {
                        override = baseConstraint;
                    }
                    catch (ClassCastException e) {
                        throw new RuntimeException("Replacement state constraint for this constraint is not an appropriate type: " + constraint.getClass().toString() + " cannot be cast to " + baseConstraint.getClass().toString(), e);
                    }
                }
                if (override != null) {
                    return (T)override;
                }
                if (override == null && ConstraintStateUtils.constraintAppliesForState(validationState, constraint, stateMapping)) {
                    return constraint;
                }
                return null;
            }
            if (ConstraintStateUtils.constraintAppliesForState(validationState, constraint, stateMapping)) {
                return constraint;
            }
            return null;
        }
        return constraint;
    }

    public static String getClientViewValidationState(Object model, View view) {
        String validationState = null;
        String path = view.getStateObjectBindingPath();
        Object stateObject = StringUtils.isNotBlank((String)path) ? ObjectPropertyUtils.getPropertyValue(model, path) : model;
        StateMapping stateMapping = view.getStateMapping();
        if (stateMapping != null) {
            validationState = stateMapping.getNextState(stateObject);
            if (stateMapping.getCustomClientSideValidationStates() != null) {
                String currentState = stateMapping.getCurrentState(stateObject);
                validationState = stateMapping.getCustomClientSideValidationStates().get(currentState);
                if (StringUtils.isBlank((String)validationState)) {
                    validationState = stateMapping.getNextState(stateObject);
                }
            }
        }
        return validationState;
    }
}

