/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary;

import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.util.CopyUtils;

/**
 * Common base for all objects that can be configured in the dictionary
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public abstract class DictionaryBeanBase implements DictionaryBean, Copyable {
    private static final long serialVersionUID = 4334492273538657771L;

    protected String namespaceCode;
    protected String componentCode;

    public DictionaryBeanBase() {}

    /**
     * @see DictionaryBean#getNamespaceCode()
     */
    @Override
    @BeanTagAttribute(name = "namespaceCode")
    public String getNamespaceCode() {
        return namespaceCode;
    }

    /**
     * Setter for the bean's associated namespace code
     *
     * @param namespaceCode
     */
    public void setNamespaceCode(String namespaceCode) {
        this.namespaceCode = namespaceCode;
    }

    /**
     * @see DictionaryBean#getComponentCode()
     */
    @Override
    @BeanTagAttribute(name = "componentCode")
    public String getComponentCode() {
        return componentCode;
    }

    /**
     * Setter for the bean's associated component code
     *
     * @param componentCode
     */
    public void setComponentCode(String componentCode) {
        this.componentCode = componentCode;
    }

    /**
     * @see Copyable#clone()
     */
    @Override
    public DictionaryBeanBase clone() throws CloneNotSupportedException {
        return (DictionaryBeanBase) super.clone();
    }

    /**
     * @see Copyable#copy()
     * @see CopyUtils#copy(Copyable)
     */
    public <T> T copy() {
        return CopyUtils.copy(this);
    }

    @Override
    public void dataDictionaryPostProcessing() {
        // Do nothing here - will be implemented by subclasses
    }
}
