/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.control;

import org.kuali.rice.krad.datadictionary.DataDictionaryDefinition;

import java.util.Map;


@Deprecated
public interface ControlDefinition extends DataDictionaryDefinition {

    boolean isDatePicker();

    void setDatePicker(boolean datePicker);

    String getDatePickerFormat();

    void setDatePickerFormat(String datePickerFormat);

    boolean isExpandedTextArea();

    void setExpandedTextArea(boolean eTextArea);

    /**
     * @return true if this ControlDefinition instance represents an HTML checkbox control
     */
    boolean isCheckbox();

    /**
     * @return true if this ControlDefinition instance represents an HTML hidden control
     */
    boolean isHidden();

    /**
     * @return true if this ControlDefinition instance represents an HTML radiobutton control
     */
    boolean isRadio();

    /**
     * @return true if this ControlDefinition instance represents an HTML select control
     */
    boolean isSelect();

    /**
     * @return true if this ControlDefinition instance represents an HTML select control
     */
    boolean isMultiselect();

    /**
     * @return true if this ControlDefinition instance represents an HTML text control
     */
    boolean isText();

    /**
     * @return true if this ControlDefinition instance represents an HTML textarea control
     */
    boolean isTextarea();

    /**
     * @return any Script associated with this control
     */
    String getScript();

    /**
     * @return true if the ControlDefinition instance represents a currency control
     */
    boolean isCurrency();

    /**
     * @return true if the ControlDefinition instance represents a kualiUser control
     */
    boolean isKualiUser();

    /**
     * @return true if the ControlDefinition instance represents a workflow workgroup control
     */
    boolean isWorkflowWorkgroup();

    /**
     * @return true if this ControlDefinition instance represents an HTML File control
     */
    boolean isFile();

    /**
     * @return true if the ControlDefinition instance represents a lookupHidden control
     */
    boolean isLookupHidden();

    /**
     * @return true if the ControlDefinition instance represents a lookupReadonly control
     */
    boolean isLookupReadonly();

    /**
     * @return true if the ControlDefinition instance represents a button control
     */
    boolean isButton();

    /**
     * @return true if the ControlDefinition instance represents a link control
     */
    boolean isLink();

    /**
     * @return true if the ControlDefinition instance represents a ranged (will render from and to fields) date control
     */
    boolean isRanged();

    /**
     * Sets the Class used to retrieve the complete range of values for radiobutton and select controls.
     */
    void setValuesFinderClass(String valuesFinderClass);

    void setValuesFinderProperties(Map<String, Object> valuesFinderProperties);

    /**
     * Sets the BO Class used for the KeyLabelBusinessObjectValueFinder to retrieve the complete range of values for
     * radiobutton and select controls.
     */
    void setBusinessObjectClass(String businessObjectClass);

    /**
     * Sets the keyAttribute used for building radiobutton and select controls.
     */
    void setKeyAttribute(String keyAttribute);

    /**
     * Sets the labelAttribute used for building radiobutton and select controls.
     */
    void setLabelAttribute(String labelAttribute);

    void setIncludeBlankRow(Boolean includeBlankRow);

    /**
     * @param includeKeyInLabel whether to include the key with the label to be displayed or not.
     */
    void setIncludeKeyInLabel(Boolean includeKeyInLabel);

    /**
     * Sets the Script
     */
    void setScript(String script);

    /**
     * @return Class used to retrieve the complete range of values for radiobutton and select controls.
     */
    String getValuesFinderClass();

    Map<String, Object> getValuesFinderProperties();

    /**
     * @return BO Class used for the KeyLabelBusinessObjectValueFinder to retrieve the complete range of values for
     *         radiobutton and select controls.
     */
    String getBusinessObjectClass();

    /**
     * @return the keyAttribute used for radiobutton and select controls.
     */
    String getKeyAttribute();

    /**
     * @return the labelAttribute used for radiobutton and select controls.
     */
    String getLabelAttribute();

    Boolean getIncludeBlankRow();

    /**
     * Gets the flag that indicates if the labels the ValuesFinder class returns should include the key.
     *
     * @return true if the key should be included in the label
     */
    Boolean getIncludeKeyInLabel();

    /**
     * Sets the size parameter for text controls.
     */
    void setSize(Integer size);

    /**
     * @return size parameters for text controls
     */
    Integer getSize();

    /**
     * Sets the rows parameter for textarea controls.
     */
    void setRows(Integer rows);

    /**
     * @return rows parameters for textarea controls
     */
    Integer getRows();

    /**
     * Sets the cols parameter for textarea controls.
     */
    void setCols(Integer cols);

    /**
     * @return cols parameter for textarea controls.
     */
    Integer getCols();

}
