/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation;

import org.kuali.rice.core.framework.persistence.jdbc.sql.SQLUtils;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.util.DataTypeUtil;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * A class that implements the required accessors and legacy processing for an attribute value reader. This provides a
 * convenient base class
 * from which other attribute value readers can be derived.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public abstract class BaseAttributeValueReader implements AttributeValueReader {

    protected String entryName;
    protected String attributeName;

    @Override
    public List<String> getCleanSearchableValues(String attributeKey) throws AttributeValidationException {
        Class<?> attributeType = getType(attributeKey);
        Object rawValue = getValue(attributeKey);
        String attributeInValue = "";

        if (rawValue != null) {
            //if a date force the format
            if (rawValue instanceof Date && !(rawValue instanceof Timestamp)) {
                attributeInValue = new SimpleDateFormat("MM-dd-yyyy").format(rawValue);
            } else {
                attributeInValue = rawValue.toString();
            }
        }

        String attributeDataType = DataTypeUtil.determineDataType(attributeType);
        return SQLUtils.getCleanedSearchableValues(attributeInValue, attributeDataType);
    }

    /**
     * @return the currentName
     */
    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    /**
     * @param currentName the currentName to set
     */
    @Override
    public void setAttributeName(String currentName) {
        this.attributeName = currentName;
    }

    /**
     * @return the entryName
     */
    @Override
    public String getEntryName() {
        return this.entryName;
    }

    @Override
    public abstract AttributeValueReader clone();

}
