/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.service;

import java.util.Map;

import org.kuali.rice.krad.uif.field.AttributeQueryResult;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;

/**
 * Provides methods for executing <code>AttributeQuery</code> instances
 * and preparing the <code>AttributeQueryResult</code> with the result of the query
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface AttributeQueryService {

    /**
     * Executes the <code>AttributeQuery</code> associated with the <code>Suggest</code> widget within
     * the field given by the Id. The given Map of key/value pairs are used to populate the criteria part of the
     * attribute query or as arguments to the query method. The fieldTerm parameter gives the current value
     * of the field that should be matched on. The query is expected to return a list of values to suggest
     *
     * @param viewPostMetadata - post metadata related to the field
     * @param fieldId - id for the attribute field to perform the query for
     * @param fieldTerm - the partial value of the query field to match
     * @param queryParameters - map of key/value pairs that are parameters to the query
     * @return AttributeQueryResult instance populated with the List&lt;String&gt; data field of result data
     */
    public AttributeQueryResult performFieldSuggestQuery(ViewPostMetadata viewPostMetadata,
            String fieldId, String fieldTerm, Map<String, String> queryParameters);

    /**
     * Executes the <code>AttributeQuery</code> associated with the field given by the id. The given Map of key/value
     * pairs are used to populate the criteria part of the attribute query or as arguments to the query method.
     * The query is expected to return a Map of field name/value pairs (unlike the suggest query which just returns
     * values for one field)
     *
     * @param viewPostMetadata - post metadata related to the field
     * @param fieldId - id for the attribute field to perform the query for
     * @param queryParameters - map of key/value pairs that are parameters to the query
     * @return AttributeQueryResult instance populated with the Map<String, String> of result field data
     */
    public AttributeQueryResult performFieldQuery(ViewPostMetadata viewPostMetadata,
            String fieldId, Map<String, String> queryParameters);

}
