/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.util.documentserializer;

/**
 * A very simple implementation of {@link PropertySerializabilityEvaluator} which simply uses the
 * provided {@link PropertySerializerTrie} as metadata to define what should be serialized.
 *
 * @author Eric Westfall
 */
public class MetadataPropertySerializabilityEvaluator extends PropertySerializabilityEvaluatorBase {

    public MetadataPropertySerializabilityEvaluator(PropertySerializerTrie metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata is required but was null");
        }
        this.serializableProperties = metadata;
    }

}
