/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation;

import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.datadictionary.exporter.ExportMap;

import java.util.regex.Pattern;

/**
 * Abstraction of the regular expressions used to validate attribute values.
 */
@Deprecated
abstract public class FieldLevelValidationPattern extends ValidationPattern {
    protected Pattern regexPattern;

    /**
     * Uses the key returned by getConfigurationRegexKey to fetch the validationPattern's regex string from the
     * ConfigurationService
     *
     * @see org.kuali.rice.krad.datadictionary.validation.ValidationPattern#getRegexString()
     */
    @Override
    protected String getRegexString() {
        return (String) CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString(
                "validationPatternRegex." + getPatternTypeName());
    }

    /**
     * @return the key used to retrieve the validationPattern's type name, which is used as the suffix of the regex
     *         property key, as
     *         the type entry in the exportMap, etc.
     */
    abstract protected String getPatternTypeName();

    /**
     * @return regular expression Pattern generated using the individual ValidationPattern subclass
     */
    @Override
    public final Pattern getRegexPattern() {
        if (regexPattern == null) {
            StringBuffer completeRegex = new StringBuffer("^");
            completeRegex.append(getRegexString());
            completeRegex.append("$");
            regexPattern = Pattern.compile(completeRegex.toString());
        }
        return regexPattern;
    }

    @Override
    public ExportMap buildExportMap(String exportKey) {
        ExportMap exportMap = new ExportMap(exportKey);

        exportMap.set("type", getPatternTypeName());

        return exportMap;
    }

    @Override
    public String getValidationErrorMessageKey() {
        StringBuilder buf = new StringBuilder();
        buf.append("error.format.").append(getClass().getName());
        return buf.toString();
    }
}
