/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.container;

import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Collection filter that removes inactive lines from a collection whose line types
 * implement the <code>Inactivatable</code> interface
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "activeCollectionFilter")
public class ActiveCollectionFilter implements CollectionFilter {
    private static final long serialVersionUID = 3273495753269940272L;

    /**
     * Iterates through the collection and if the collection line type implements <code>Inactivatable</code>,
     * active indexes are added to the show indexes list
     *
     * {@inheritDoc}
     */
    @Override
    public List<Integer> filter(View view, Object model, CollectionGroup collectionGroup) {
        // get the collection for this group from the model
        List<Object> modelCollection =
                ObjectPropertyUtils.getPropertyValue(model, collectionGroup.getBindingInfo().getBindingPath());

        // iterate through and add only active indexes
        List<Integer> showIndexes = new ArrayList<Integer>();
        if (modelCollection != null) {
            int lineIndex = 0;
            for (Object line : modelCollection) {
                if (line instanceof Inactivatable) {
                    boolean active = ((Inactivatable) line).isActive();
                    if (active) {
                        showIndexes.add(lineIndex);
                    }
                }
                lineIndex++;
            }
        }

        return showIndexes;
    }
}
