/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle.finalize;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.kuali.rice.krad.uif.view.View;

/**
 * Add templates defined on this component to the view for rendering.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class AddViewTemplatesTask extends ViewLifecycleTaskBase<Component> {

    public AddViewTemplatesTask() {
        super(Component.class);
    }

    @Override
    protected void performLifecycleTask() {
        Component component = (Component) getElementState().getElement();
        View view = ViewLifecycle.getView();

        // add the components template to the views list of components
        if (!component.isSelfRendered() && StringUtils.isNotBlank(component.getTemplate())) {
            String template = component.getTemplate();
            view.addViewTemplate(template);
            
            for (String additionalTemplate : component.getAdditionalTemplates()) {
                view.addViewTemplate(additionalTemplate);
            }
        }
    }

}
