/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.datadictionary.DataDictionaryPropertyUtils;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.datadictionary.InactivationBlockingDefinition;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

@BeanTag(name="businessObjectEntry")
public class BusinessObjectEntry
extends DataObjectEntry {
    private static final Logger LOG = LogManager.getLogger(BusinessObjectEntry.class);

    public void setBusinessObjectClass(Class<? extends BusinessObject> businessObjectClass) {
        super.setDataObjectClass(businessObjectClass);
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) dataObjectClass");
        }
        if (this.getRelationships() != null) {
            for (RelationshipDefinition rd : this.getRelationships()) {
                rd.setSourceClass(businessObjectClass);
            }
        }
    }

    public Class<? extends BusinessObject> getBusinessObjectClass() {
        return super.getDataObjectClass();
    }

    public void setBaseBusinessObjectClass(Class<? extends BusinessObject> baseBusinessObjectClass) {
        super.setBaseDataObjectClass(baseBusinessObjectClass);
    }

    @BeanTagAttribute(name="baseBusinessObjectClass")
    public Class<? extends BusinessObject> getBaseBusinessObjectClass() {
        return super.getBaseDataObjectClass();
    }

    @Override
    public void completeValidation() {
        this.completeValidation(new ValidationTrace());
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        super.completeValidation(tracer);
        try {
            if (this.inactivationBlockingDefinitions != null && !this.inactivationBlockingDefinitions.isEmpty()) {
                for (InactivationBlockingDefinition inactivationBlockingDefinition : this.inactivationBlockingDefinitions) {
                    inactivationBlockingDefinition.completeValidation(this.getDataObjectClass(), null, tracer.getCopy());
                }
            }
        }
        catch (Exception ex) {
            String[] currentValues = new String[]{"BO Class = " + String.valueOf(this.getBusinessObjectClass()), "Exception = " + ex.getMessage()};
            tracer.createError("Unable to validate BO Entry", currentValues);
            LOG.error("Exception while validating BusinessObjectEntry: " + String.valueOf(this.getBusinessObjectClass()), (Throwable)ex);
        }
    }

    @Override
    public void dataDictionaryPostProcessing() {
        super.dataDictionaryPostProcessing();
        if (this.inactivationBlockingDefinitions != null) {
            for (InactivationBlockingDefinition ibd : this.inactivationBlockingDefinitions) {
                ibd.setBusinessObjectClass(this.getBusinessObjectClass());
                if (StringUtils.isNotBlank((String)ibd.getBlockedReferencePropertyName()) && ibd.getBlockedBusinessObjectClass() == null) {
                    ibd.setBlockedBusinessObjectClass(DataDictionaryPropertyUtils.getAttributeClass(this.getDataObjectClass(), ibd.getBlockedReferencePropertyName()));
                }
                ibd.setBlockingReferenceBusinessObjectClass(this.getBusinessObjectClass());
            }
        }
    }
}

