/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint.provider;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.rice.krad.datadictionary.validation.capability.Constrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.provider.ConstraintProvider;
import org.kuali.rice.krad.datadictionary.validation.constraint.resolver.ConstraintResolver;

public abstract class BaseConstraintProvider<T extends Constrainable>
implements ConstraintProvider<T> {
    protected Map<String, ConstraintResolver<T>> resolverMap;

    public void init() {
        if (this.resolverMap == null) {
            this.resolverMap = new HashMap<String, ConstraintResolver<T>>();
        }
    }

    @Override
    public List<Constraint> getConstraints(T definition, Class<? extends Constraint> constraintType) {
        ConstraintResolver<T> resolver;
        if (this.resolverMap == null) {
            this.init();
        }
        if ((resolver = this.resolverMap.get(constraintType.getName())) == null) {
            return null;
        }
        return resolver.resolve(definition);
    }

    public Map<String, ConstraintResolver<T>> getResolverMap() {
        return this.resolverMap;
    }

    public void setResolverMap(Map<String, ConstraintResolver<T>> resolverMap) {
        this.resolverMap = resolverMap;
    }
}

