/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.document;

import java.util.Map;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentViewAuthorizerBase;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.form.DocumentFormBase;

public class TransactionalDocumentViewAuthorizerBase
extends DocumentViewAuthorizerBase {
    private static final long serialVersionUID = -6361662425078612737L;
    private PessimisticLockService pessimisticLockService;

    @Override
    public boolean canEditView(View view, ViewModel model, Person user) {
        boolean canEditView = super.canEditView(view, model, user);
        Map<String, Object> context = view.getContext();
        DocumentEntry documentEntry = (DocumentEntry)context.get("DocumentEntry");
        if (!documentEntry.getUsePessimisticLocking()) {
            return canEditView;
        }
        DocumentFormBase documentForm = (DocumentFormBase)model;
        Document document = documentForm.getDocument();
        return this.getPessimisticLockService().establishPessimisticLocks(document, user, canEditView);
    }

    protected PessimisticLockService getPessimisticLockService() {
        if (this.pessimisticLockService == null) {
            this.pessimisticLockService = KRADServiceLocatorWeb.getPessimisticLockService();
        }
        return this.pessimisticLockService;
    }

    protected void setPessimisticLockService(PessimisticLockService pessimisticLockService) {
        this.pessimisticLockService = pessimisticLockService;
    }
}

