/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.service.impl.RemoteModuleServiceBase;
import org.kuali.rice.krad.util.UrlFactory;

public class ModuleServiceBase
extends RemoteModuleServiceBase
implements ModuleService {
    protected static final Logger LOG = LogManager.getLogger(ModuleServiceBase.class);

    @Override
    public <T extends ExternalizableBusinessObject> T getExternalizableBusinessObject(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        Class<T> implementationClass = this.getExternalizableBusinessObjectImplementation(businessObjectClass);
        ExternalizableBusinessObject businessObject = (ExternalizableBusinessObject)this.getLegacyDataAdapter().findByPrimaryKey(implementationClass, fieldValues);
        return (T)businessObject;
    }

    @Override
    public <T extends ExternalizableBusinessObject> List<T> getExternalizableBusinessObjectsList(Class<T> externalizableBusinessObjectClass, Map<String, Object> fieldValues) {
        Class<T> implementationClass = this.getExternalizableBusinessObjectImplementation(externalizableBusinessObjectClass);
        return this.getLegacyDataAdapter().findMatching(implementationClass, fieldValues);
    }

    @Override
    @Deprecated
    public String getExternalizableBusinessObjectInquiryUrl(Class inquiryBusinessObjectClass, Map<String, String[]> parameters) {
        if (!this.isExternalizable(inquiryBusinessObjectClass)) {
            return "";
        }
        Class implementationClass = this.getExternalizableBusinessObjectImplementation(inquiryBusinessObjectClass);
        if (implementationClass == null) {
            LOG.error("Can't find ExternalizableBusinessObject implementation class for " + inquiryBusinessObjectClass.getName());
            throw new RuntimeException("Can't find ExternalizableBusinessObject implementation class for interface " + inquiryBusinessObjectClass.getName());
        }
        String businessObjectClassAttribute = implementationClass.getName();
        return UrlFactory.parameterizeUrl((String)this.getInquiryUrl(inquiryBusinessObjectClass), (Properties)this.getUrlParameters(businessObjectClassAttribute, parameters));
    }

    @Override
    @Deprecated
    protected String getInquiryUrl(Class inquiryBusinessObjectClass) {
        String riceBaseUrl = "";
        String potentialUrlAddition = "";
        if (this.goToCentralRiceForInquiry()) {
            riceBaseUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("kr.url");
        } else {
            riceBaseUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url");
            potentialUrlAddition = "kr/";
        }
        Object inquiryUrl = riceBaseUrl;
        if (!((String)inquiryUrl).endsWith("/")) {
            inquiryUrl = (String)inquiryUrl + "/";
        }
        return (String)inquiryUrl + potentialUrlAddition + "inquiry.do";
    }

    @Override
    public boolean isExternalizableBusinessObjectLookupable(Class boClass) {
        Class implementationClass = this.getExternalizableBusinessObjectImplementation(boClass);
        return KRADServiceLocatorWeb.getLegacyDataAdapter().hasLocalLookup(implementationClass);
    }

    @Override
    public boolean isExternalizableBusinessObjectInquirable(Class boClass) {
        return KRADServiceLocatorWeb.getLegacyDataAdapter().hasLocalInquiry(boClass);
    }

    @Override
    @Deprecated
    public String getExternalizableBusinessObjectLookupUrl(Class inquiryBusinessObjectClass, Map<String, String> parameters) {
        Properties urlParameters = new Properties();
        String riceBaseUrl = "";
        String potentialUrlAddition = "";
        if (this.goToCentralRiceForInquiry()) {
            riceBaseUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("kr.url");
        } else {
            riceBaseUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url");
            potentialUrlAddition = "kr/";
        }
        Object lookupUrl = riceBaseUrl;
        if (!((String)lookupUrl).endsWith("/")) {
            lookupUrl = (String)lookupUrl + "/";
        }
        lookupUrl = parameters.containsKey("multipleValues") ? (String)lookupUrl + potentialUrlAddition + "multipleValueLookup.do" : (String)lookupUrl + potentialUrlAddition + "lookup.do";
        for (String paramName : parameters.keySet()) {
            urlParameters.put(paramName, parameters.get(paramName));
        }
        Class clazz = this.getExternalizableBusinessObjectImplementation(inquiryBusinessObjectClass);
        urlParameters.put("businessObjectClassName", clazz == null ? "" : clazz.getName());
        return UrlFactory.parameterizeUrl((String)lookupUrl, (Properties)urlParameters);
    }

    @Override
    public boolean goToCentralRiceForInquiry() {
        return false;
    }

    @Override
    protected String getBaseLookupUrl() {
        if (this.goToCentralRiceForInquiry()) {
            return RemoteModuleServiceBase.BaseLookupUrlsHolder.remoteKradBaseLookupUrl;
        }
        return RemoteModuleServiceBase.BaseLookupUrlsHolder.localKradBaseLookupUrl;
    }

    protected RunMode getRunMode(String module) {
        String propertyName = module + ".mode";
        String runMode = ConfigContext.getCurrentContextConfig().getProperty(propertyName);
        if (StringUtils.isBlank((String)runMode)) {
            throw new ConfigurationException("Failed to determine run mode for module '" + module + "'.  Please be sure to set configuration parameter '" + propertyName + "'");
        }
        return RunMode.valueOf((String)runMode.toUpperCase());
    }
}

