/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentRequestAuthorizationCache;
import org.kuali.rice.krad.document.DocumentViewAuthorizerBase;
import org.kuali.rice.krad.document.DocumentViewPresentationControllerBase;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.view.FormView;

@BeanTag(name="documentView", parent="Uif-DocumentView")
public class DocumentView
extends FormView {
    private static final long serialVersionUID = 2251983409572774175L;
    private Class<? extends Document> documentClass;
    private boolean allowsNoteAttachments = true;
    private boolean allowsNoteFYI = false;
    private boolean displayTopicFieldInNotes = false;
    private boolean superUserView = false;
    private Class<? extends KeyValuesFinder> attachmentTypesValuesFinderClass;

    public DocumentView() {
        this.setRequestAuthorizationCacheClass(DocumentRequestAuthorizationCache.class);
    }

    @Override
    public void performInitialization(Object model) {
        DocumentViewPresentationControllerBase documentViewPresentationControllerBase;
        DocumentViewAuthorizerBase documentViewAuthorizerBase;
        super.performInitialization(model);
        DocumentEntry documentEntry = this.getDocumentEntryForView();
        this.pushObjectToContext("DocumentEntry", documentEntry);
        String documentTypeName = documentEntry.getDocumentTypeName();
        DocumentType documentType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(documentTypeName);
        if (this.getHeader() != null && StringUtils.isBlank((String)this.getHeaderText())) {
            this.setHeaderText(documentType.getLabel());
        }
        if (this.getAuthorizer() == null) {
            this.setAuthorizer(new DocumentViewAuthorizerBase());
        }
        if (this.getAuthorizer() instanceof DocumentViewAuthorizerBase && (documentViewAuthorizerBase = (DocumentViewAuthorizerBase)this.getAuthorizer()).getDocumentAuthorizer() == null) {
            documentViewAuthorizerBase.setDocumentAuthorizerClass(documentEntry.getDocumentAuthorizerClass());
        }
        if (this.getPresentationController() == null) {
            this.setPresentationController(new DocumentViewPresentationControllerBase());
        }
        if (this.getPresentationController() instanceof DocumentViewPresentationControllerBase && (documentViewPresentationControllerBase = (DocumentViewPresentationControllerBase)this.getPresentationController()).getDocumentPresentationController() == null) {
            documentViewPresentationControllerBase.setDocumentPresentationControllerClass(documentEntry.getDocumentPresentationControllerClass());
        }
        this.getObjectPathToConcreteClassMapping().put(this.getDefaultBindingObjectPath(), this.getDocumentClass());
    }

    protected DocumentEntry getDocumentEntryForView() {
        DocumentEntry documentEntry = KRADServiceLocatorWeb.getDocumentDictionaryService().getDocumentEntryByClass(this.getDocumentClass());
        if (documentEntry == null) {
            throw new RuntimeException("Unable to find document entry for document class: " + this.getDocumentClass().getName());
        }
        return documentEntry;
    }

    @BeanTagAttribute(name="explanationDataMaxLength")
    public int getExplanationDataMaxLength() {
        return KRADServiceLocatorWeb.getDataDictionaryService().getAttributeMaxLength(Note.class, "noteText") - (CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("message.disapprove.noteTextIntro") + " ").length();
    }

    @BeanTagAttribute
    public Class<? extends Document> getDocumentClass() {
        return this.documentClass;
    }

    public void setDocumentClass(Class<? extends Document> documentClass) {
        this.documentClass = documentClass;
    }

    @BeanTagAttribute
    public boolean isAllowsNoteAttachments() {
        return this.allowsNoteAttachments;
    }

    public void setAllowsNoteAttachments(boolean allowsNoteAttachments) {
        this.allowsNoteAttachments = allowsNoteAttachments;
    }

    @BeanTagAttribute
    public boolean isAllowsNoteFYI() {
        return this.allowsNoteFYI;
    }

    public void setAllowsNoteFYI(boolean allowsNoteFYI) {
        this.allowsNoteFYI = allowsNoteFYI;
    }

    @BeanTagAttribute
    public boolean isDisplayTopicFieldInNotes() {
        return this.displayTopicFieldInNotes;
    }

    public void setDisplayTopicFieldInNotes(boolean displayTopicFieldInNotes) {
        this.displayTopicFieldInNotes = displayTopicFieldInNotes;
    }

    @BeanTagAttribute
    public Class<? extends KeyValuesFinder> getAttachmentTypesValuesFinderClass() {
        return this.attachmentTypesValuesFinderClass;
    }

    public void setAttachmentTypesValuesFinderClass(Class<? extends KeyValuesFinder> attachmentTypesValuesFinderClass) {
        this.attachmentTypesValuesFinderClass = attachmentTypesValuesFinderClass;
    }

    public boolean isSuperUserView() {
        return this.superUserView;
    }

    public void setSuperUserView(boolean superUserView) {
        this.checkMutable(true);
        this.superUserView = superUserView;
    }
}

