/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplateAttribute;

public final class NaturalLanguageTemplateAttributeGenTest {
    private static final String XML = "paste xml output here";
    private static final String ATTRIBUTE_DEFINITION_ID = "ATTRIBUTE_DEFINITION_ID";
    private static final String ID = "ID";
    private static final String NATURAL_LANGUAGE_TEMPLATE_ID = "NATURAL_LANGUAGE_TEMPLATE_ID";
    private static final String VALUE = "VALUE";

    @Test
    public void test_NaturalLanguageTemplateAttribute_set_validation_id_success_null() {
        NaturalLanguageTemplateAttribute.Builder builder = NaturalLanguageTemplateAttribute.Builder.create();
        builder.setId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplateAttribute_set_validation_id_fail_empty() {
        NaturalLanguageTemplateAttribute.Builder builder = NaturalLanguageTemplateAttribute.Builder.create();
        builder.setId("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplateAttribute_set_validation_id_fail_whitespace() {
        NaturalLanguageTemplateAttribute.Builder builder = NaturalLanguageTemplateAttribute.Builder.create();
        builder.setId("    ");
    }

    @Test
    public void test_NaturalLanguageTemplateAttribute_Builder_create() {
        NaturalLanguageTemplateAttribute.Builder.create();
    }

    @Test
    public void test_NaturalLanguageTemplateAttribute_Builder_create_and_build() {
        NaturalLanguageTemplateAttribute.Builder builder = NaturalLanguageTemplateAttribute.Builder.create();
        builder.build();
    }

    @Test
    @Ignore
    public void test_NaturalLanguageTemplateAttribute_xml_marshaling() throws Exception {
        NaturalLanguageTemplateAttribute naturalLanguageTemplateAttribute = NaturalLanguageTemplateAttributeGenTest.buildFullNaturalLanguageTemplateAttribute();
        this.assertXmlMarshaling(naturalLanguageTemplateAttribute, XML);
    }

    public void assertXmlMarshaling(Object naturalLanguageTemplateAttribute, String expectedXml) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{NaturalLanguageTemplateAttribute.class});
        Marshaller marshaller = jc.createMarshaller();
        StringWriter stringWriter = new StringWriter();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal(naturalLanguageTemplateAttribute, (Writer)stringWriter);
        String xml = stringWriter.toString();
        System.out.println(xml);
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        Object actual = unmarshaller.unmarshal((Reader)new StringReader(xml));
        Object expected = unmarshaller.unmarshal((Reader)new StringReader(expectedXml));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static NaturalLanguageTemplateAttribute buildFullNaturalLanguageTemplateAttribute() {
        NaturalLanguageTemplateAttribute.Builder builder = NaturalLanguageTemplateAttribute.Builder.create();
        builder.setId(ID);
        NaturalLanguageTemplateAttribute naturalLanguageTemplateAttribute = builder.build();
        return naturalLanguageTemplateAttribute;
    }
}

