/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api.engine;

import org.kuali.rice.core.api.exception.RiceRuntimeException;

/**
 * A runtime exception which indicates that some resource required during engine
 * execution is unavailable. 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class EngineResourceUnavailableException extends RiceRuntimeException {

	private static final long serialVersionUID = 4936540099245413634L;

	/**
	 * @see RiceRuntimeException#RiceRuntimeException()
	 */
	public EngineResourceUnavailableException() {
		super();
	}

	/**
	 * @see RiceRuntimeException#RiceRuntimeException(String, Throwable)
     * @param message the exception message
     * @param cause the root Throwable cause.
     */
	public EngineResourceUnavailableException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @see RiceRuntimeException#RiceRuntimeException(String)
     * @param message the exception message
	 */
	public EngineResourceUnavailableException(String message) {
		super(message);
	}

	/**
	 * @see RiceRuntimeException#RiceRuntimeException(Throwable)
     * @param cause the root Throwable cause.
	 */
	public EngineResourceUnavailableException(Throwable cause) {
		super(cause);
	}
	
}
