/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.agenda;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeEntryDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeRuleEntry;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeSubAgendaEntry;
import org.w3c.dom.Element;

@XmlRootElement(name="agendaTreeDefinition")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="AgendaTreeDefinition", propOrder={"agendaId", "entries", "_futureElements"})
public final class AgendaTreeDefinition
extends AbstractDataTransferObject {
    private static final long serialVersionUID = 3355519740298280591L;
    @XmlElement(name="agendaId", required=false)
    private final String agendaId;
    @XmlElements(value={@XmlElement(name="rule", type=AgendaTreeRuleEntry.class, required=false), @XmlElement(name="subAgenda", type=AgendaTreeSubAgendaEntry.class, required=false)})
    private final List<AgendaTreeEntryDefinitionContract> entries;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private AgendaTreeDefinition() {
        this.agendaId = null;
        this.entries = null;
    }

    private AgendaTreeDefinition(Builder builder) {
        this.agendaId = builder.getAgendaId();
        this.entries = builder.getEntries();
    }

    public String getAgendaId() {
        return this.agendaId;
    }

    public List<AgendaTreeEntryDefinitionContract> getEntries() {
        if (this.entries == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.entries);
    }

    public static class Builder
    implements ModelBuilder,
    Serializable {
        private static final long serialVersionUID = 7981215392039022620L;
        private String agendaId;
        private List<AgendaTreeEntryDefinitionContract> entries = new ArrayList<AgendaTreeEntryDefinitionContract>();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public void setAgendaId(String agendaId) {
            if (StringUtils.isBlank((String)agendaId)) {
                throw new IllegalArgumentException("agendaItemId was null or blank");
            }
            this.agendaId = agendaId;
        }

        public void addRuleEntry(AgendaTreeRuleEntry ruleEntry) {
            if (ruleEntry == null) {
                throw new IllegalArgumentException("ruleEntry was null");
            }
            this.entries.add(ruleEntry);
        }

        public void addSubAgendaEntry(AgendaTreeSubAgendaEntry subAgendaEntry) {
            if (subAgendaEntry == null) {
                throw new IllegalArgumentException("subAgendaEntry was null");
            }
            this.entries.add(subAgendaEntry);
        }

        public String getAgendaId() {
            return this.agendaId;
        }

        public List<AgendaTreeEntryDefinitionContract> getEntries() {
            return this.entries;
        }

        public AgendaTreeDefinition build() {
            return new AgendaTreeDefinition(this);
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/krms/v2_0/AgendaTreeDefinition";
    }

    static class Elements {
        static final String AGENDA_ID = "agendaId";
        static final String ENTRIES = "entries";
        static final String RULE = "rule";
        static final String SUB_AGENDA = "subAgenda";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "agendaTreeDefinition";
        static final String TYPE_NAME = "AgendaTreeDefinition";

        Constants() {
        }
    }
}

