/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api.engine;

import java.util.List;

/**
 * Results of an {@link Engine}'s execution
 *
 * @see ResultEvent
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface EngineResults {

    /**
     * Return the ResultEvent for the given index
     * @param index of the ResultEvent to return
     * @return {@link ResultEvent} whose index was given
     *
     * @deprecated use {@link #getAllResults()} instead, this method will be removed in a future version
     */
    @Deprecated
	public ResultEvent getResultEvent(int index);

    /**
     * Return the list of ResultEvents
     * @return List&lt;ResultEvent&*gt; all the results
     */
	public List<ResultEvent> getAllResults();

    /**
     * Return the ResultEvents of the given type
     * @param type of result events to return
     * @return List&lt;ResultEvent&gt; of the given type
     */
	public List<ResultEvent> getResultsOfType(String type);

    /**
     * Return the attribute of the given key
     * @param key to return the attribute of
     * @return Object that is the attribute for the given key
     */
	public Object getAttribute(String key);

    /**
     * Set the attribute of the given values
     * @param key to set the given attribute of
     * @param attribute to set as the given key's attribute
     */
	public void setAttribute(String key, Object attribute);

    /**
     * Add the given {@link ResultEvent}
     * @param result to add
     */
	public void addResult(ResultEvent result);
}
