/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api;

import org.kuali.rice.core.api.CoreConstants;

/**
 * KRMS Constants
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public final class KrmsConstants {

    public static final String KRMS_NAMESPACE = "KR-RULE";
    public static final String KRMS_DATA_SOURCE = "krmsDataSource";

    /**
     * MAINTAIN_KRMS_AGENDA
     */
    public static final String MAINTAIN_KRMS_AGENDA = "Maintain KRMS Agenda";

    /**
     * SERVICE_PATH_SOAP
     */
    public final static String SERVICE_PATH_SOAP = "soap/" + Namespaces.MODULE_NAME + "/" + CoreConstants.Versions.VERSION_2_0;

    /**
     * KRMS distributed cache bean id
     */
    public static final String KRMS_DISTRIBUTED_CACHE = "krmsDistributedCacheManager";

    /**
     * Namespaces
     */
	public final static class Namespaces {
        /**
         * Namespaces MODULE_NAME
         */
		public static final String MODULE_NAME = "krms";

        /**
         * Namespaces KRMS_NAMESPACE_PREFIX
         */
        public static final String KRMS_NAMESPACE_PREFIX = CoreConstants.Namespaces.ROOT_NAMESPACE_PREFIX + "/" + MODULE_NAME;

        /**
         * Namespace for the kew module which is compatible with Kuali Rice 2.0.x.
         */
        public static final String KRMS_NAMESPACE_2_0 = KRMS_NAMESPACE_PREFIX + "/" + CoreConstants.Versions.VERSION_2_0;
	}

}

