/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.proposition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.krms.api.repository.LogicalOperator;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinitionContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameter;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.w3c.dom.Element;

@XmlRootElement(name="proposition")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="PropositionType", propOrder={"id", "description", "ruleId", "typeId", "propositionTypeCode", "parameters", "compoundOpCode", "compoundComponents", "versionNumber", "compoundSequenceNumber", "_futureElements"})
public final class PropositionDefinition
extends AbstractDataTransferObject
implements PropositionDefinitionContract {
    private static final long serialVersionUID = 2783959459503209577L;
    @XmlElement(name="id", required=true)
    private String id;
    @XmlElement(name="description", required=true)
    private String description;
    @XmlElement(name="typeId", required=true)
    private String typeId;
    @XmlElement(name="ruleId", required=true)
    private String ruleId;
    @XmlElement(name="propositionTypeCode", required=true)
    private String propositionTypeCode;
    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter", required=false)
    private List<PropositionParameter> parameters;
    @XmlElement(name="compoundOpCode", required=false)
    private String compoundOpCode;
    @XmlElementWrapper(name="compoundComponents", required=false)
    @XmlElement(name="proposition", required=false)
    private List<PropositionDefinition> compoundComponents;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="compoundSequenceNumber", required=false)
    private Integer compoundSequenceNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private PropositionDefinition() {
        this.id = null;
        this.description = null;
        this.typeId = null;
        this.propositionTypeCode = null;
        this.parameters = null;
        this.compoundOpCode = null;
        this.compoundSequenceNumber = null;
        this.compoundComponents = null;
        this.versionNumber = null;
    }

    private PropositionDefinition(Builder builder) {
        this.id = builder.getId();
        this.description = builder.getDescription();
        this.ruleId = builder.getRuleId();
        this.typeId = builder.getTypeId();
        this.propositionTypeCode = builder.getPropositionTypeCode();
        ArrayList<PropositionParameter> paramList = new ArrayList<PropositionParameter>();
        for (PropositionParameter.Builder b : builder.parameters) {
            b.setProposition(builder);
            paramList.add(b.build());
        }
        this.parameters = Collections.unmodifiableList(paramList);
        this.compoundOpCode = builder.getCompoundOpCode();
        this.compoundSequenceNumber = builder.getCompoundSequenceNumber();
        ArrayList<PropositionDefinition> componentList = new ArrayList<PropositionDefinition>();
        if (builder.compoundComponents != null) {
            for (Builder b : builder.compoundComponents) {
                componentList.add(b.build());
            }
            this.compoundComponents = Collections.unmodifiableList(componentList);
        }
        this.versionNumber = builder.getVersionNumber();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getRuleId() {
        return this.ruleId;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    @Override
    public String getPropositionTypeCode() {
        return this.propositionTypeCode;
    }

    public List<PropositionParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public String getCompoundOpCode() {
        return this.compoundOpCode;
    }

    public List<PropositionDefinition> getCompoundComponents() {
        return this.compoundComponents;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    @Override
    public Integer getCompoundSequenceNumber() {
        return this.compoundSequenceNumber;
    }

    public static class Builder
    implements PropositionDefinitionContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = -6889320709850568900L;
        private String id;
        private String description;
        private String ruleId;
        private String typeId;
        private String propositionTypeCode;
        private List<PropositionParameter.Builder> parameters;
        private String compoundOpCode;
        private Integer compoundSequenceNumber;
        private List<Builder> compoundComponents;
        private RuleDefinition.Builder rule;
        private Long versionNumber;

        private Builder(String propId, String propTypeCode, String ruleId, String typeId, List<PropositionParameter.Builder> parameters) {
            this.setId(propId);
            this.setPropositionTypeCode(propTypeCode);
            this.setRuleId(ruleId);
            this.setTypeId(typeId);
            this.setParameters(parameters);
        }

        public Builder compoundOpCode(String opCode) {
            this.setCompoundOpCode(opCode);
            return this;
        }

        public Builder compoundComponents(List<Builder> components) {
            this.setCompoundComponents(components);
            return this;
        }

        public static Builder create(String propId, String propTypeCode, String ruleId, String typeId, List<PropositionParameter.Builder> parameters) {
            return new Builder(propId, propTypeCode, ruleId, typeId, parameters);
        }

        public static Builder create(PropositionDefinitionContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract is null");
            }
            ArrayList<PropositionParameter.Builder> paramBuilderList = new ArrayList<PropositionParameter.Builder>();
            if (contract.getParameters() != null) {
                for (PropositionParameterContract propositionParameterContract : contract.getParameters()) {
                    PropositionParameter.Builder myBuilder = PropositionParameter.Builder.create(propositionParameterContract);
                    paramBuilderList.add(myBuilder);
                }
            }
            Builder builder = new Builder(contract.getId(), contract.getPropositionTypeCode(), contract.getRuleId(), contract.getTypeId(), paramBuilderList);
            ArrayList<Builder> arrayList = new ArrayList<Builder>();
            if (contract.getCompoundComponents() != null) {
                for (PropositionDefinitionContract propositionDefinitionContract : contract.getCompoundComponents()) {
                    Builder pBuilder = Builder.create(propositionDefinitionContract);
                    arrayList.add(pBuilder);
                }
                builder.setCompoundComponents(arrayList);
            }
            builder.setCompoundOpCode(contract.getCompoundOpCode());
            builder.setCompoundSequenceNumber(contract.getCompoundSequenceNumber());
            builder.setDescription(contract.getDescription());
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public void setId(String propId) {
            if (propId != null && StringUtils.isBlank((String)propId)) {
                throw new IllegalArgumentException("proposition id must not be blank");
            }
            this.id = propId;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setTypeId(String typeId) {
            this.typeId = typeId;
        }

        public void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public void setRule(RuleDefinition.Builder rule) {
            if (rule != null && !StringUtils.isBlank((String)rule.getId())) {
                this.setRuleId(rule.getId());
            }
            this.rule = rule;
        }

        public void setPropositionTypeCode(String propTypeCode) {
            if (StringUtils.isBlank((String)propTypeCode)) {
                throw new IllegalArgumentException("proposition type code is blank");
            }
            if (!PropositionType.VALID_TYPE_CODES.contains(propTypeCode)) {
                throw new IllegalArgumentException("invalid proposition type code");
            }
            this.propositionTypeCode = propTypeCode;
        }

        public void setParameters(List<PropositionParameter.Builder> parameters) {
            this.parameters = parameters == null || parameters.isEmpty() ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(parameters);
        }

        public void setCompoundOpCode(String opCode) {
            if (StringUtils.isBlank((String)opCode)) {
                return;
            }
            if (!LogicalOperator.OP_CODES.contains(opCode)) {
                throw new IllegalArgumentException("invalid opCode value");
            }
            this.compoundOpCode = opCode;
        }

        public void setCompoundSequenceNumber(Integer seqNo) {
            this.compoundSequenceNumber = seqNo;
        }

        public void setCompoundComponents(List<Builder> components) {
            if (components == null || components.isEmpty()) {
                this.compoundComponents = new ArrayList<Builder>();
                return;
            }
            this.compoundComponents = new ArrayList<Builder>(components);
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getRuleId() {
            return this.ruleId;
        }

        @Override
        public String getTypeId() {
            return this.typeId;
        }

        @Override
        public String getPropositionTypeCode() {
            return this.propositionTypeCode;
        }

        public List<PropositionParameter.Builder> getParameters() {
            return this.parameters;
        }

        @Override
        public String getCompoundOpCode() {
            return this.compoundOpCode;
        }

        @Override
        public Integer getCompoundSequenceNumber() {
            return this.compoundSequenceNumber;
        }

        public List<Builder> getCompoundComponents() {
            return this.compoundComponents;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public PropositionDefinition build() {
            return new PropositionDefinition(this);
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/krms/v2_0/PropositionType";
    }

    public static class Elements {
        static final String ID = "id";
        static final String DESC = "description";
        static final String RULE_ID = "ruleId";
        static final String TYPE_ID = "typeId";
        static final String PROP_TYPE_CODE = "propositionTypeCode";
        static final String PARAMETER = "parameter";
        static final String PARAMETERS = "parameters";
        static final String CMPND_OP_CODE = "compoundOpCode";
        static final String CMPND_SEQ_NO = "compoundSequenceNumber";
        static final String CMPND_COMPONENTS = "compoundComponents";
        static final String CMPND_COMPONENT = "proposition";
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "proposition";
        static final String TYPE_NAME = "PropositionType";

        Constants() {
        }
    }
}

