/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine;

import java.util.Collection;
import java.util.Iterator;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.engine.Term;
import org.kuali.rice.krms.framework.engine.CollectionOperator;
import org.kuali.rice.krms.framework.engine.ComparableTermBasedProposition;
import org.kuali.rice.krms.framework.engine.PropositionResult;
import org.kuali.rice.krms.framework.engine.ResultLogger;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperator;
import org.kuali.rice.krms.framework.engine.result.BasicResult;

public class CollectionOfComparablesTermBasedProposition<T>
extends ComparableTermBasedProposition<T> {
    private static final ResultLogger LOG = ResultLogger.getInstance();
    private CollectionOperator collectionOper;
    private Term term;

    public CollectionOfComparablesTermBasedProposition(CollectionOperator collectionOper, ComparisonOperator compareOper, Term term, T expectedValue) {
        super(compareOper, term, expectedValue);
        this.term = term;
        this.collectionOper = collectionOper;
    }

    @Override
    public PropositionResult evaluate(ExecutionEnvironment environment) {
        boolean collatedResult = this.collectionOper.getInitialCollatedResult();
        Collection termValue = (Collection)environment.resolveTerm(this.term, (Object)this);
        if (termValue != null) {
            Comparable item;
            Iterator i$ = termValue.iterator();
            while (i$.hasNext() && !this.collectionOper.shortCircuit(collatedResult = this.collectionOper.reduce(this.compare(item = (Comparable)i$.next()), collatedResult))) {
            }
        }
        if (LOG.isEnabled(environment)) {
            LOG.logResult(new BasicResult("Proposition Evaluated", this, environment, collatedResult));
        }
        return new PropositionResult(collatedResult);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.collectionOper.toString());
        sb.append(" " + super.toString());
        return sb.toString();
    }
}

