/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.engine.ExecutionFlag;
import org.kuali.rice.krms.api.repository.LogicalOperator;
import org.kuali.rice.krms.framework.engine.Proposition;
import org.kuali.rice.krms.framework.engine.PropositionResult;
import org.kuali.rice.krms.framework.engine.ResultLogger;
import org.kuali.rice.krms.framework.engine.result.BasicResult;

public final class CompoundProposition
implements Proposition {
    private static final ResultLogger LOG = ResultLogger.getInstance();
    private final LogicalOperator logicalOperator;
    private final List<Proposition> propositions;

    public CompoundProposition(LogicalOperator logicalOperator, List<Proposition> propositions) {
        if (propositions == null || propositions.isEmpty()) {
            throw new IllegalArgumentException("Propositions must be non-null and non-empty.");
        }
        if (logicalOperator == null) {
            throw new IllegalArgumentException("Logical operator must be non-null.");
        }
        this.logicalOperator = logicalOperator;
        this.propositions = new ArrayList<Proposition>(propositions);
    }

    @Override
    public PropositionResult evaluate(ExecutionEnvironment environment) {
        PropositionResult result = this.evaluateInner(environment);
        if (LOG.isEnabled(environment)) {
            LOG.logResult(new BasicResult("Proposition Evaluated", this, environment, result.getResult()));
        }
        return result;
    }

    private PropositionResult evaluateInner(ExecutionEnvironment environment) {
        boolean evaluateAll = environment.getExecutionOptions().getFlag(ExecutionFlag.EVALUATE_ALL_PROPOSITIONS);
        if (this.logicalOperator == LogicalOperator.AND) {
            boolean collatedResult = true;
            for (Proposition proposition : this.propositions) {
                PropositionResult singleResult = proposition.evaluate(environment);
                this.logPropositionResult(proposition, singleResult, environment);
                if (singleResult.getResult()) continue;
                collatedResult = false;
                if (evaluateAll) continue;
                break;
            }
            return new PropositionResult(collatedResult);
        }
        if (this.logicalOperator == LogicalOperator.OR) {
            boolean collatedResult = false;
            for (Proposition proposition : this.propositions) {
                PropositionResult singleResult = proposition.evaluate(environment);
                this.logPropositionResult(proposition, singleResult, environment);
                if (!singleResult.getResult()) continue;
                collatedResult = true;
                if (evaluateAll) continue;
                break;
            }
            return new PropositionResult(collatedResult);
        }
        throw new IllegalStateException("Invalid logical operator: " + this.logicalOperator);
    }

    public void logPropositionResult(Proposition proposition, PropositionResult propositionResult, ExecutionEnvironment environment) {
        if (!proposition.isCompound()) {
            LOG.logResult(new BasicResult(propositionResult.getExecutionDetails(), "Proposition Evaluated", (Object)proposition, environment, propositionResult.getResult()));
        }
    }

    @Override
    public List<Proposition> getChildren() {
        return Collections.unmodifiableList(this.propositions);
    }

    @Override
    public boolean isCompound() {
        return true;
    }
}

