/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine.expression;

import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.engine.Term;
import org.kuali.rice.krms.api.engine.TermResolutionException;

/**
 * An implementation of {@link Expression} which resolves the given {@link Term}.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public final class TermExpression implements Expression<Object> {

	private final Term term;

    /**
     * Create a TermExpression with the given value
     * @param term {@link Term} to invoke upon.
     */
	public TermExpression(Term term) {
		this.term = term;
	}

	/**
	 * @see org.kuali.rice.krms.framework.engine.expression.Expression#invoke(org.kuali.rice.krms.api.engine.ExecutionEnvironment)
	 * @throws TermResolutionException if there is a problem resolving the {@link Term}
	 */
	@Override
	public Object invoke(ExecutionEnvironment environment) {
	    return environment.resolveTerm(term, this);
	}

}
