/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.type;

import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.framework.engine.Proposition;

/**
 * Interface defining loading a {@link Proposition} from a {@link PropositionDefinition}
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface PropositionTypeService {

    /**
     * Load the Proposition given the propositionDefinition
     * @param propositionDefinition to create the {@link Proposition} from
     * @return {@link Proposition} created from the given {@link PropositionDefinition}
     */
	public Proposition loadProposition(PropositionDefinition propositionDefinition);
	
}
