/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine.expression;

import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.engine.IncompatibleTypeException;

/**
 * The {@link Expression} used in construction, will be invoked with the given {@link ExecutionEnvironment}.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public final class BooleanValidatingExpression implements Expression<Boolean> {

	private final Expression<? extends Object> expression;

    /**
     * Constructor
     * @param expression {@link Expression} to set the expression to
     */
	public BooleanValidatingExpression(Expression<? extends Object> expression) {
		this.expression = expression;
	}

    @Override
	public Boolean invoke(ExecutionEnvironment environment) {
		Object result = expression.invoke(environment);
		if (result instanceof Boolean) {
			return (Boolean)result;
		}
		throw new IncompatibleTypeException("Type mismatch when executing expression.", result, Boolean.class);
	}
	
}
