/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine;

import javax.swing.event.EventListenerList;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.engine.ExecutionFlag;
import org.kuali.rice.krms.api.engine.ResultEvent;
import org.kuali.rice.krms.framework.engine.result.ResultListener;

public class ResultLogger {
    private EventListenerList listenerList = new EventListenerList();

    private ResultLogger() {
    }

    public static ResultLogger getInstance() {
        return KRMSLoggerLoader.INSTANCE;
    }

    public void addListener(ResultListener resultListener) {
        this.listenerList.add(ResultListener.class, resultListener);
    }

    public void removeListener(ResultListener resultListener) {
        this.listenerList.remove(ResultListener.class, resultListener);
    }

    public void logResult(ResultEvent event) {
        if (this.isEnabled(event.getEnvironment())) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = 1; i < listeners.length; i += 2) {
                ((ResultListener)listeners[i]).handleEvent(event);
            }
        }
    }

    public boolean isEnabled(ExecutionEnvironment environment) {
        return environment != null && environment.getExecutionOptions() != null && environment.getExecutionOptions().getFlag(ExecutionFlag.LOG_EXECUTION);
    }

    private static class KRMSLoggerLoader {
        private static final ResultLogger INSTANCE = new ResultLogger();

        private KRMSLoggerLoader() {
        }
    }
}

