/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.krad.inquiry.InquirableImpl;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.SpaceField;
import org.kuali.rice.krad.uif.layout.GridLayoutManager;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.form.InquiryForm;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.impl.repository.PropositionBo;
import org.kuali.rice.krms.impl.repository.RuleBo;

public class RuleStudentInquiryViewHelperServiceImpl
extends InquirableImpl {
    private static int ID = 1;
    private static final String PROPOSITION_GROUP_ID = "propositionGroup";
    private static final String PROPOSITION_ID = "proposition";

    public void addCustomContainerComponents(ViewModel model, Container container) {
        RuleBo ruleDataObj;
        PropositionBo proposition;
        if (PROPOSITION_GROUP_ID.equals(container.getId()) && (proposition = (ruleDataObj = (RuleBo)((InquiryForm)model).getDataObject()).getProposition()) != null) {
            if (PropositionType.COMPOUND.getCode().equals(proposition.getPropositionTypeCode())) {
                ArrayList<Component> groups = new ArrayList<Component>();
                this.handleCompoundPropositions(groups, proposition);
                container.setItems(groups);
            } else {
                Message simplePropName = ComponentFactory.getMessage();
                simplePropName.setId("proposition_" + ID++);
                simplePropName.setMessageText(proposition.getDescription());
                ArrayList<Message> simpleProps = new ArrayList<Message>();
                simpleProps.add(simplePropName);
                container.setItems(simpleProps);
            }
        }
    }

    private void handleCompoundPropositions(List<Component> components, PropositionBo proposition) {
        Group compoundGroup = RuleStudentInquiryViewHelperServiceImpl.getPropositionGroup();
        compoundGroup.setId(String.valueOf("propositionGroup_" + ID++));
        ((GridLayoutManager)compoundGroup.getLayoutManager()).setNumberOfColumns(2);
        ArrayList<Object> componentItems = new ArrayList<Object>();
        Message propositionName = ComponentFactory.getMessage();
        propositionName.setId("proposition_" + ID++);
        propositionName.setMessageText(proposition.getDescription());
        componentItems.add(propositionName);
        SpaceField spaceField1 = ComponentFactory.getSpaceField();
        spaceField1.setId("space_" + ID++);
        componentItems.add(spaceField1);
        SpaceField spaceField2 = ComponentFactory.getSpaceField();
        spaceField2.setId("space_" + ID++);
        componentItems.add(spaceField2);
        if (proposition.getCompoundComponents() != null) {
            int loopCounter = 0;
            for (PropositionBo nestedProposition : proposition.getCompoundComponents()) {
                if (loopCounter != 0) {
                    SpaceField spaceField3 = ComponentFactory.getSpaceField();
                    spaceField3.setId("space_" + ID++);
                    componentItems.add(spaceField3);
                    Message operator = ComponentFactory.getMessage();
                    operator.setId("proposition_" + ID++);
                    operator.setMessageText(Operator.fromCode(proposition.getCompoundOpCode()).toString());
                    componentItems.add(operator);
                    SpaceField spaceField4 = ComponentFactory.getSpaceField();
                    spaceField4.setId("space_" + ID++);
                    componentItems.add(spaceField4);
                }
                if (PropositionType.COMPOUND.getCode().equals(nestedProposition.getPropositionTypeCode())) {
                    this.handleCompoundPropositions(components, nestedProposition);
                } else {
                    Message simplePropName = ComponentFactory.getMessage();
                    simplePropName.setId("proposition_" + ID++);
                    simplePropName.setMessageText(nestedProposition.getDescription());
                    componentItems.add(simplePropName);
                }
                ++loopCounter;
            }
        }
        compoundGroup.setItems(componentItems);
        components.add((Component)compoundGroup);
    }

    private static Group getPropositionGroup() {
        Group group = ComponentFactory.getGroupGridBodyOnly();
        group.getDisclosure().setId(String.valueOf(ID++));
        return group;
    }

    private static enum Operator {
        OR("|"),
        AND("&");

        private String code;

        private Operator(String code) {
            this.code = code;
        }

        private static Operator fromCode(String code) {
            if (code == null) {
                return null;
            }
            for (Operator operator : Operator.values()) {
                if (!operator.code.equals(code)) continue;
                return operator;
            }
            throw new IllegalArgumentException("Failed to locate the Operator with the given code: " + code);
        }
    }
}

