/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.form.MaintenanceDocumentForm;
import org.kuali.rice.krms.api.KrmsApiServiceLocator;
import org.kuali.rice.krms.api.repository.RuleManagementService;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.function.FunctionDefinition;
import org.kuali.rice.krms.api.repository.operator.CustomOperator;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.api.repository.typerelation.RelationshipType;
import org.kuali.rice.krms.api.repository.typerelation.TypeTypeRelation;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperator;
import org.kuali.rice.krms.impl.ui.AgendaEditor;
import org.kuali.rice.krms.impl.util.KrmsServiceLocatorInternal;

public class PropositionOpCodeValuesFinder
extends UifKeyValuesFinderBase {
    private static final Logger LOG = Logger.getLogger(PropositionOpCodeValuesFinder.class);
    private static final List<KeyValue> LABELS;

    public List<KeyValue> getKeyValues(ViewModel model) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>(LABELS);
        MaintenanceDocumentForm maintenanceForm = (MaintenanceDocumentForm)model;
        AgendaEditor agendaEditor = (AgendaEditor)maintenanceForm.getDocument().getNewMaintainableObject().getDataObject();
        ContextDefinition context = this.getRuleManagementService().getContext(agendaEditor.getAgenda().getContextId());
        keyValues.addAll(this.getCustomOperatorsKeyValuesForContextType(context.getTypeId()));
        return keyValues;
    }

    private List<KeyValue> getCustomOperatorsKeyValuesForContextType(String contextTypeId) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        if (contextTypeId == null) {
            return keyValues;
        }
        List typeRelations = this.getTypeRepositoryService().findTypeTypeRelationsByFromType(contextTypeId);
        for (TypeTypeRelation typeRelation : typeRelations) {
            KrmsTypeDefinition krmsType;
            Object service;
            if (!typeRelation.getRelationshipType().equals((Object)RelationshipType.USAGE_ALLOWED) || (service = this.getTypeServiceImplementation(krmsType = this.getTypeRepositoryService().getTypeById(typeRelation.getToTypeId()))) == null || !(service instanceof CustomOperator)) continue;
            keyValues.add((KeyValue)this.getKeyValueForCustomOperator(krmsType, (CustomOperator)service));
        }
        return keyValues;
    }

    private ConcreteKeyValue getKeyValueForCustomOperator(KrmsTypeDefinition krmsType, CustomOperator customOperator) {
        FunctionDefinition operatorFunctionDefinition = customOperator.getOperatorFunctionDefinition();
        String key = "customOperator:" + krmsType.getNamespace() + ":" + krmsType.getServiceName();
        return new ConcreteKeyValue(key, operatorFunctionDefinition.getName());
    }

    private Object getTypeServiceImplementation(KrmsTypeDefinition krmsType) {
        Object service = null;
        if (krmsType != null && !StringUtils.isEmpty((String)krmsType.getServiceName())) {
            QName serviceQName = new QName(krmsType.getNamespace(), krmsType.getServiceName());
            service = GlobalResourceLoader.getService((QName)serviceQName);
        }
        return service;
    }

    private KrmsTypeRepositoryService getTypeRepositoryService() {
        return TypeRepositoryServiceHolder.typeRepositoryService;
    }

    private RuleManagementService getRuleManagementService() {
        return RuleManagementServiceHolder.ruleManagementService;
    }

    static {
        ArrayList<ConcreteKeyValue> labels = new ArrayList<ConcreteKeyValue>(ComparisonOperator.values().length);
        for (ComparisonOperator operator : ComparisonOperator.values()) {
            labels.add(new ConcreteKeyValue(operator.getCode(), operator.getCode()));
        }
        LABELS = Collections.unmodifiableList(labels);
    }

    private static class RuleManagementServiceHolder {
        static final RuleManagementService ruleManagementService = (RuleManagementService)KrmsServiceLocatorInternal.getService("ruleManagementService");

        private RuleManagementServiceHolder() {
        }
    }

    private static class TypeRepositoryServiceHolder {
        static final KrmsTypeRepositoryService typeRepositoryService = KrmsApiServiceLocator.getKrmsTypeRepositoryService();

        private TypeRepositoryServiceHolder() {
        }
    }
}

