/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.repository.language;

import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplaterContract;

/**
 * A dead simple implementation of the templater contract for testing
 * @author nwright
 */
public class SimpleNaturalLanguageTemplater implements NaturalLanguageTemplaterContract {

    @Override
    public String translate(NaturalLanguageTemplate naturalLanguageTemplate, Map<String, Object> contextMap) {
        String template = naturalLanguageTemplate != null ? naturalLanguageTemplate.getTemplate() : "Empty Template";

        StringBuilder sb = new StringBuilder(template);
        sb.append(" applied with the following ");
        sb.append (contextMap.size());        
        sb.append(" variables: ");
        String comma = "";
        for (String key : contextMap.keySet()) {
            sb.append (comma);
            comma = ",";
            sb.append ("[");
            sb.append (key);
            sb.append ("=");
            sb.append (contextMap.get(key));
            sb.append ("]");
        }
        return sb.toString();
    }
     
}
