/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.ui;

import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.impl.cache.DistributedCacheManagerDecorator;
import org.kuali.rice.krad.maintenance.MaintainableImpl;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.util.KRADConstants;
import org.kuali.rice.krms.api.KrmsConstants;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.RepositoryBoIncrementer;

import java.util.Map;

/**
 * {@link org.kuali.rice.krad.maintenance.Maintainable} for the {@link ContextBo}
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * */
public class ContextMaintainable extends MaintainableImpl {

    private static final RepositoryBoIncrementer contextIdIncrementer = new RepositoryBoIncrementer(ContextBo.CONTEXT_SEQ_NAME);

    @Override
    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        ContextBo newContext = (ContextBo) document.getNewMaintainableObject().getDataObject();

        newContext.setId(contextIdIncrementer.getNewId());

        super.processAfterNew(document, requestParameters);    
    }

    @Override
    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        ContextBo context = (ContextBo) document.getNewMaintainableObject().getDataObject();

        context.setId(contextIdIncrementer.getNewId());

        super.processAfterCopy(document,
                requestParameters);
    }

    @Override
    public void saveDataObject() {
        super.saveDataObject();

        //flush context cache
        DistributedCacheManagerDecorator distributedCacheManagerDecorator =
                GlobalResourceLoader.getService(KrmsConstants.KRMS_DISTRIBUTED_CACHE);
        distributedCacheManagerDecorator.getCache(ContextDefinition.Cache.NAME).clear();
    }

    @Override
    public Object retrieveObjectForEditOrCopy(MaintenanceDocument document, Map<String, String> dataObjectKeys) {

        ContextBo contextBo = (ContextBo) super.retrieveObjectForEditOrCopy(document, dataObjectKeys);

        if (KRADConstants.MAINTENANCE_COPY_ACTION.equals(getMaintenanceAction())) {
            document.getDocumentHeader().setDocumentDescription("New Context Document");

            contextBo = contextBo.copyContext(" Copy " + System.currentTimeMillis());
        }

        return contextBo;
    }
}
