/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.ojb;

import org.apache.ojb.broker.accesslayer.conversions.ConversionException;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;
import org.kuali.rice.krms.api.repository.typerelation.RelationshipType;

/**
 * This class performs an OJB conversion between a String and the code value in the RelationType enum.
 *
 * @author Kuali Student Team
 */
public class OjbRelationshipTypeStringConversion implements FieldConversion {

    @Override
    public Object javaToSql(Object source) throws ConversionException {
        if (source instanceof RelationshipType) {
            if (source != null) {
                RelationshipType relationshipType = (RelationshipType) source;
                return relationshipType.getCode();
            }
        }
        return null;
    }

    @Override
    public Object sqlToJava(Object source) throws ConversionException {
        if (source instanceof String) {
            if (source != null) {
                String s = (String) source;
                for (RelationshipType relType : RelationshipType.values()) {
                    if (relType.getCode().equals(s)) {
                        return relType;
                    }
                }
            }
        }
        return null;
    }
}
