/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.repository;

import org.kuali.rice.krms.api.repository.typerelation.RelationshipType;
import org.kuali.rice.krms.api.repository.typerelation.TypeTypeRelation;
import java.util.List;

/**
 * This is the interface for accessing repository {@link TypeTypeRelationBo} related business objects.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * 
 */
public interface TypeTypeRelationBoService {


    /**
     * This will create a {@link TypeTypeRelation} exactly like the parameter passed in.
     * 
     * @param typeTypeRelation  The TypeTypeRelation to create.
     * @throws IllegalArgumentException if the TypeTypeRelation is null.
     * @throws IllegalStateException if the TypeTypeRelation already exists in the system.
     * @return a {@link TypeTypeRelation} exactly like the parameter passed in.
     * 
     */
    TypeTypeRelation createTypeTypeRelation(TypeTypeRelation typeTypeRelation);

    /**
     * Retrieves a TypeTypeRelation from the repository based on the given id.
     * 
     * @param typeTypeRelationId to retrieve.
     * @return a {@link TypeTypeRelation} identified by the given id.  
     * A null reference is returned if an invalid or non-existent id is supplied.
     * 
     */
    TypeTypeRelation getTypeTypeRelation(String typeTypeRelationId);

    /**
     * This will update an existing {@link TypeTypeRelation}.
     * 
     * @param typeTypeRelation  The TypeTypeRelation to update.
     * @throws IllegalArgumentException if the TypeTypeRelation is null.
     * @throws IllegalStateException if the TypeTypeRelation does not exists in the system.
     * 
     */
    TypeTypeRelation updateTypeTypeRelation(TypeTypeRelation typeTypeRelation);

    /**
     * Delete the {@link TypeTypeRelation} with the given id.
     * 
     * @param typeTypeRelationId to delete.
     * @throws IllegalArgumentException if the TypeTypeRelation is null.
     * @throws IllegalStateException if the TypeTypeRelation does not exists in the system
     * 
     */
    void deleteTypeTypeRelation(String typeTypeRelationId);

    List<TypeTypeRelation> findTypeTypeRelationsByFromType(String fromTypeId);

    List<TypeTypeRelation> findTypeTypeRelationsByToType(String toTypeId);

    List<TypeTypeRelation> findTypeTypeRelationsByRelationshipType(RelationshipType relationshipType);

    List<TypeTypeRelation> findTypeTypeRelationsBySequenceNumber(Integer sequenceNumber);

    /**
     * Converts a mutable {@link TypeTypeRelationBo} to its immutable counterpart, {@link TypeTypeRelation}.
     * @param typeTypeRelationBo the mutable business object.
     * @return a {@link TypeTypeRelation} the immutable object.
     * 
     */
    TypeTypeRelation to(TypeTypeRelationBo typeTypeRelationBo);

    /**
     * Converts a immutable {@link TypeTypeRelation} to its mutable {@link TypeTypeRelationBo} counterpart.
     * @param typeTypeRelation the immutable object.
     * @return a {@link TypeTypeRelationBo} the mutable TypeTypeRelationBo.
     * 
     */
    TypeTypeRelationBo from(TypeTypeRelation typeTypeRelation);

}
