/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.provider.repository;

import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.framework.engine.Rule;
import org.kuali.rice.krms.framework.type.RuleTypeService;
import org.kuali.rice.krms.impl.type.KrmsTypeResolver;

final class LazyRule
implements Rule {
    private final RuleDefinition ruleDefinition;
    private final KrmsTypeResolver typeResolver;
    private final Object mutex = new Object();
    private volatile Rule rule;

    LazyRule(RuleDefinition ruleDefinition, KrmsTypeResolver typeResolver) {
        this.ruleDefinition = ruleDefinition;
        this.typeResolver = typeResolver;
        this.rule = null;
    }

    public boolean evaluate(ExecutionEnvironment environment) {
        return this.getRule().evaluate(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rule getRule() {
        Rule localRule = this.rule;
        if (localRule == null) {
            Object object = this.mutex;
            synchronized (object) {
                localRule = this.rule;
                if (localRule == null) {
                    this.rule = localRule = this.constructRule();
                }
            }
        }
        return localRule;
    }

    private Rule constructRule() {
        RuleTypeService ruleTypeService = this.typeResolver.getRuleTypeService(this.ruleDefinition);
        Rule rule = ruleTypeService.loadRule(this.ruleDefinition);
        if (rule == null) {
            rule = new Rule(this){

                public boolean evaluate(ExecutionEnvironment environment) {
                    return false;
                }
            };
        }
        return rule;
    }
}

