/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krms.api.repository.term.TermDefinition;
import org.kuali.rice.krms.api.repository.term.TermDefinitionContract;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinition;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinitionContract;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinitionContract;
import org.kuali.rice.krms.impl.repository.BusinessObjectServiceMigrationUtils;
import org.kuali.rice.krms.impl.repository.ContextValidTermBo;
import org.kuali.rice.krms.impl.repository.TermBo;
import org.kuali.rice.krms.impl.repository.TermBoService;
import org.kuali.rice.krms.impl.repository.TermResolverAttributeBo;
import org.kuali.rice.krms.impl.repository.TermResolverBo;
import org.kuali.rice.krms.impl.repository.TermSpecificationBo;
import org.springframework.util.CollectionUtils;

public class TermBoServiceImpl
implements TermBoService {
    private DataObjectService dataObjectService;

    public TermSpecificationDefinition getTermSpecificationById(String id) {
        TermSpecificationDefinition result = null;
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("id must not be blank or null");
        }
        TermSpecificationBo termSpecificationBo = (TermSpecificationBo)this.getDataObjectService().find(TermSpecificationBo.class, (Object)id);
        if (termSpecificationBo != null) {
            List<ContextValidTermBo> contextValidTermBos = BusinessObjectServiceMigrationUtils.findMatching(this.getDataObjectService(), ContextValidTermBo.class, Collections.singletonMap("termSpecification.id", termSpecificationBo.getId()));
            if (contextValidTermBos != null) {
                for (ContextValidTermBo contextValidTerm : contextValidTermBos) {
                    termSpecificationBo.getContextIds().add(contextValidTerm.getContextId());
                }
            }
            result = TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)termSpecificationBo).build();
        }
        return result;
    }

    public TermSpecificationDefinition createTermSpecification(TermSpecificationDefinition termSpec) {
        if (!StringUtils.isBlank((String)termSpec.getId())) {
            throw new RiceIllegalArgumentException("for creation, TermSpecification.id must be null");
        }
        TermSpecificationBo termSpecBo = TermSpecificationBo.from(termSpec);
        if (!CollectionUtils.isEmpty((Collection)termSpec.getContextIds())) {
            for (String contextId : termSpec.getContextIds()) {
                ContextValidTermBo contextValidTerm = new ContextValidTermBo();
                contextValidTerm.setContextId(contextId);
                contextValidTerm.setTermSpecification(termSpecBo);
                termSpecBo.getContextValidTerms().add(contextValidTerm);
            }
        }
        termSpecBo = (TermSpecificationBo)this.getDataObjectService().save((Object)termSpecBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        return TermSpecificationBo.to(termSpecBo);
    }

    public void updateTermSpecification(TermSpecificationDefinition termSpec) throws RiceIllegalArgumentException {
        TermSpecificationDefinition toUpdate;
        if (termSpec == null) {
            throw new IllegalArgumentException("term specification is null");
        }
        String termSpecificationId = termSpec.getId();
        TermSpecificationBo existing = (TermSpecificationBo)this.getDataObjectService().find(TermSpecificationBo.class, (Object)termSpecificationId);
        if (existing == null) {
            throw new IllegalStateException("the term specification does not exist: " + String.valueOf(termSpec));
        }
        if (!existing.getId().equals(termSpec.getId())) {
            TermSpecificationDefinition.Builder builder = TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)termSpec);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = termSpec;
        }
        TermSpecificationBo boToUpdate = TermSpecificationBo.from(toUpdate);
        this.reconcileContextValidTerms(existing, boToUpdate);
        this.getDataObjectService().save((Object)boToUpdate, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    private void reconcileContextValidTerms(TermSpecificationBo existing, TermSpecificationBo boToUpdate) {
        for (ContextValidTermBo contextValidTerm : existing.getContextValidTerms()) {
            if (!boToUpdate.getContextIds().contains(contextValidTerm.getContextId())) continue;
            boToUpdate.getContextValidTerms().add(contextValidTerm);
        }
        for (String contextId : boToUpdate.getContextIds()) {
            boolean alreadyInContextValidTerms = false;
            for (ContextValidTermBo contextValidTerm : boToUpdate.getContextValidTerms()) {
                if (!contextId.equals(contextValidTerm.getContextId())) continue;
                alreadyInContextValidTerms = true;
                break;
            }
            if (alreadyInContextValidTerms) continue;
            ContextValidTermBo contextValidTerm = new ContextValidTermBo();
            contextValidTerm.setContextId(contextId);
            contextValidTerm.setTermSpecification(boToUpdate);
            boToUpdate.getContextValidTerms().add(contextValidTerm);
        }
    }

    public void deleteTermSpecification(String id) throws RiceIllegalArgumentException {
        if (id == null) {
            throw new RiceIllegalArgumentException("agendaId is null");
        }
        TermSpecificationBo existing = (TermSpecificationBo)this.getDataObjectService().find(TermSpecificationBo.class, (Object)id);
        if (existing == null) {
            throw new IllegalStateException("the TermSpecification to delete does not exists: " + id);
        }
        this.getDataObjectService().delete((Object)existing);
    }

    public TermDefinition createTerm(TermDefinition termDef) {
        if (!StringUtils.isBlank((String)termDef.getId())) {
            throw new RiceIllegalArgumentException("for creation, TermDefinition.id must be null");
        }
        TermBo termBo = TermBo.from(termDef);
        termBo = (TermBo)this.getDataObjectService().save((Object)termBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        return TermBo.to(termBo);
    }

    public void updateTerm(TermDefinition term) throws RiceIllegalArgumentException {
        TermDefinition toUpdate;
        if (term == null) {
            throw new IllegalArgumentException("term is null");
        }
        String termId = term.getId();
        TermBo existing = (TermBo)this.getDataObjectService().find(TermBo.class, (Object)termId);
        if (existing == null) {
            throw new IllegalStateException("the term resolver does not exist: " + String.valueOf(term));
        }
        if (!existing.getId().equals(term.getId())) {
            TermDefinition.Builder builder = TermDefinition.Builder.create((TermDefinitionContract)term);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = term;
        }
        TermBo boToUpdate = TermBo.from(toUpdate);
        this.getDataObjectService().save((Object)boToUpdate, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    public void deleteTerm(String id) throws RiceIllegalArgumentException {
        if (id == null) {
            throw new RiceIllegalArgumentException("termId is null");
        }
        TermBo existing = (TermBo)this.getDataObjectService().find(TermBo.class, (Object)id);
        if (existing == null) {
            throw new IllegalStateException("the term to delete does not exists: " + id);
        }
        this.getDataObjectService().delete((Object)existing);
    }

    public TermResolverDefinition createTermResolver(TermResolverDefinition termResolver) {
        if (!StringUtils.isBlank((String)termResolver.getId())) {
            throw new RiceIllegalArgumentException("for creation, TermResolverDefinition.id must be null");
        }
        TermResolverBo termResolverBo = TermResolverBo.from(termResolver);
        termResolverBo = (TermResolverBo)this.getDataObjectService().save((Object)termResolverBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        return TermResolverBo.to(termResolverBo);
    }

    public void updateTermResolver(TermResolverDefinition termResolver) throws RiceIllegalArgumentException {
        TermResolverDefinition toUpdate;
        if (termResolver == null) {
            throw new IllegalArgumentException("term resolver is null");
        }
        String termResolverId = termResolver.getId();
        TermResolverBo existing = (TermResolverBo)this.getDataObjectService().find(TermResolverBo.class, (Object)termResolverId);
        if (existing == null) {
            throw new IllegalStateException("the term resolver does not exist: " + String.valueOf(termResolver));
        }
        if (!existing.getId().equals(termResolver.getId())) {
            TermResolverDefinition.Builder builder = TermResolverDefinition.Builder.create((TermResolverDefinitionContract)termResolver);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = termResolver;
        }
        TermResolverBo boToUpdate = TermResolverBo.from(toUpdate);
        QueryByCriteria crit = QueryByCriteria.Builder.forAttribute((String)"termResolverId", (Object)toUpdate.getId()).build();
        this.getDataObjectService().deleteMatching(TermResolverAttributeBo.class, crit);
        this.getDataObjectService().save((Object)boToUpdate, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    public void deleteTermResolver(String id) throws RiceIllegalArgumentException {
        if (id == null) {
            throw new RiceIllegalArgumentException("agendaId is null");
        }
        TermSpecificationBo existing = (TermSpecificationBo)this.getDataObjectService().find(TermSpecificationBo.class, (Object)id);
        if (existing == null) {
            throw new IllegalStateException("the TermResolver to delete does not exists: " + id);
        }
        this.getDataObjectService().delete((Object)existing);
    }

    public TermDefinition getTerm(String id) {
        TermDefinition result = null;
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("id must not be blank or null");
        }
        TermBo termBo = (TermBo)this.getDataObjectService().find(TermBo.class, (Object)id);
        if (termBo != null) {
            result = TermBo.to(termBo);
        }
        return result;
    }

    public TermResolverDefinition getTermResolverById(String id) {
        TermResolverDefinition result = null;
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("id must not be blank or null");
        }
        TermResolverBo termResolverBo = (TermResolverBo)this.getDataObjectService().find(TermResolverBo.class, (Object)id);
        if (termResolverBo != null) {
            result = TermResolverBo.to(termResolverBo);
        }
        return result;
    }

    public List<TermResolverDefinition> findTermResolversByOutputId(String id, String namespace) {
        List<TermResolverDefinition> results = null;
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("id must not be blank or null");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new RiceIllegalArgumentException("namespace must not be blank or null");
        }
        HashMap<String, String> critMap = new HashMap<String, String>(2);
        critMap.put("outputId", id);
        critMap.put("namespace", namespace);
        QueryByCriteria crit = QueryByCriteria.Builder.andAttributes(critMap).build();
        QueryResults termResolverBos = this.getDataObjectService().findMatching(TermResolverBo.class, crit);
        if (!CollectionUtils.isEmpty((Collection)termResolverBos.getResults())) {
            results = new ArrayList<TermResolverDefinition>(termResolverBos.getResults().size());
            for (TermResolverBo termResolverBo : termResolverBos.getResults()) {
                results.add(TermResolverBo.to(termResolverBo));
            }
        } else {
            results = Collections.emptyList();
        }
        return results;
    }

    public List<TermResolverDefinition> findTermResolversByNamespace(String namespace) {
        List<TermResolverDefinition> results = null;
        if (StringUtils.isBlank((String)namespace)) {
            throw new RiceIllegalArgumentException("namespace must not be blank or null");
        }
        QueryByCriteria crit = QueryByCriteria.Builder.forAttribute((String)"namespace", (Object)namespace).build();
        QueryResults termResolverBos = this.getDataObjectService().findMatching(TermResolverBo.class, crit);
        if (!CollectionUtils.isEmpty((Collection)termResolverBos.getResults())) {
            results = new ArrayList<TermResolverDefinition>(termResolverBos.getResults().size());
            for (TermResolverBo termResolverBo : termResolverBos.getResults()) {
                if (termResolverBo == null) continue;
                results.add(TermResolverBo.to(termResolverBo));
            }
        } else {
            results = Collections.emptyList();
        }
        return results;
    }

    public TermResolverDefinition getTermResolverByNameAndNamespace(String name, String namespace) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is null or blank");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("namespace", namespace);
        TermResolverBo bo = (TermResolverBo)this.getDataObjectService().find(TermResolverBo.class, map);
        return TermResolverBo.to(bo);
    }

    public TermSpecificationDefinition getTermSpecificationByNameAndNamespace(String name, String namespace) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is null or blank");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("namespace", namespace);
        TermSpecificationBo bo = BusinessObjectServiceMigrationUtils.findSingleMatching(this.getDataObjectService(), TermSpecificationBo.class, map);
        return TermSpecificationBo.to(bo);
    }

    public List<TermSpecificationDefinition> findAllTermSpecificationsByContextId(String contextId) {
        List<TermSpecificationDefinition> results = null;
        if (StringUtils.isBlank((String)contextId)) {
            throw new RiceIllegalArgumentException("contextId must not be blank or null");
        }
        QueryByCriteria crit = QueryByCriteria.Builder.forAttribute((String)"contextId", (Object)contextId).build();
        QueryResults contextValidTerms = this.getDataObjectService().findMatching(ContextValidTermBo.class, crit);
        if (!CollectionUtils.isEmpty((Collection)contextValidTerms.getResults())) {
            results = new ArrayList<TermSpecificationDefinition>(contextValidTerms.getResults().size());
            for (ContextValidTermBo validTerm : contextValidTerms.getResults()) {
                results.add(TermSpecificationBo.to(validTerm.getTermSpecification()));
            }
        } else {
            results = Collections.emptyList();
        }
        return results;
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KRADServiceLocator.getDataObjectService();
        }
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

