/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.type;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.framework.engine.BasicRule;
import org.kuali.rice.krms.framework.engine.Rule;
import org.kuali.rice.krms.framework.type.RuleTypeService;
import org.kuali.rice.krms.impl.provider.repository.RepositoryToEngineTranslator;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;

/**
 * Base class for {@link org.kuali.rice.krms.framework.type.RuleTypeService} implementations, providing
 * boilerplate for attribute building and merging from various sources.
 */
public class RuleTypeServiceBase extends KrmsTypeServiceBase implements RuleTypeService {

    public static final RuleTypeService defaultRuleTypeService = new RuleTypeServiceBase();

    private RepositoryToEngineTranslator translator;

    @Override
    public Rule loadRule(RuleDefinition ruleDefinition) {
            if (ruleDefinition == null) { throw new RiceIllegalArgumentException("ruleDefinition must not be null"); }
            if (ruleDefinition.getAttributes() == null) { throw new RiceIllegalArgumentException("ruleDefinition must not be null");}

        return new BasicRule(ruleDefinition.getName(),
                getTranslator().translatePropositionDefinition(ruleDefinition.getProposition()),
                getTranslator().translateActionDefinitions(ruleDefinition.getActions()));
    }

    public RepositoryToEngineTranslator getTranslator() {
        if (translator == null) {
            translator = KrmsRepositoryServiceLocator.getKrmsRepositoryToEngineTranslator();
        }
        return translator;
    }

    public void setTranslator(RepositoryToEngineTranslator translator) {
        this.translator = translator;
    }
}
