/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.api.bus.support;

import java.net.URL;
import javax.xml.namespace.QName;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.api.bus.ServiceBus;
import org.kuali.rice.ksb.api.bus.support.ServiceBusExporter;
import org.kuali.rice.ksb.api.bus.support.SoapServiceDefinition;
import org.springframework.beans.factory.InitializingBean;

public class CallbackServiceExporter
implements InitializingBean {
    private String localServiceName;
    private String serviceNameSpaceURI;
    private QName serviceName;
    private String servicePath;
    private URL endpointUrl;
    private Boolean busSecurity = Boolean.TRUE;
    private String serviceInterface;
    private Object callbackService;
    private ServiceBus serviceBus;

    public final void afterPropertiesSet() throws Exception {
        if (this.getCallbackService() == null) {
            throw new IllegalStateException("No callback service was provided to this exporter.");
        }
        ServiceBusExporter serviceBusExporter = this.createServiceBusExporter();
        serviceBusExporter.afterPropertiesSet();
    }

    protected ServiceBusExporter createServiceBusExporter() {
        ServiceBusExporter serviceBusExporter = new ServiceBusExporter();
        serviceBusExporter.setServiceDefinition(this.createSoapServiceDefinition());
        return serviceBusExporter;
    }

    protected SoapServiceDefinition createSoapServiceDefinition() {
        SoapServiceDefinition serviceDefinition = new SoapServiceDefinition();
        serviceDefinition.setLocalServiceName(this.getLocalServiceName());
        serviceDefinition.setServiceNameSpaceURI(this.getServiceNameSpaceURI());
        serviceDefinition.setServiceName(this.getServiceName());
        serviceDefinition.setService(this.getCallbackService());
        serviceDefinition.setServicePath(this.getServicePath());
        serviceDefinition.setEndpointUrl(this.getEndpointUrl());
        serviceDefinition.setServiceInterface(this.getServiceInterface());
        serviceDefinition.setJaxWsService(true);
        serviceDefinition.setBusSecurity(this.getBusSecurity());
        serviceDefinition.setServiceVersion(ConfigContext.getCurrentContextConfig().getRiceVersion());
        return serviceDefinition;
    }

    protected final String getLocalServiceName() {
        return this.localServiceName;
    }

    public final void setLocalServiceName(String localServiceName) {
        this.localServiceName = localServiceName;
    }

    public final String getServiceNameSpaceURI() {
        return this.serviceNameSpaceURI;
    }

    public final void setServiceNameSpaceURI(String serviceNameSpaceURI) {
        this.serviceNameSpaceURI = serviceNameSpaceURI;
    }

    public final QName getServiceName() {
        return this.serviceName;
    }

    public final void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public final String getServicePath() {
        return this.servicePath;
    }

    public final void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public final URL getEndpointUrl() {
        return this.endpointUrl;
    }

    public final void setEndpointUrl(URL endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public final Boolean getBusSecurity() {
        return this.busSecurity;
    }

    public final void setBusSecurity(Boolean busSecurity) {
        this.busSecurity = busSecurity;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public Object getCallbackService() {
        return this.callbackService;
    }

    public void setCallbackService(Object callbackService) {
        this.callbackService = callbackService;
    }

    public final ServiceBus getServiceBus() {
        return this.serviceBus;
    }

    public final void setServiceBus(ServiceBus serviceBus) {
        this.serviceBus = serviceBus;
    }
}

