/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
package org.kuali.rice.ksb.api.messaging;

public final class CallMetadata {
    private final String methodName;
    private final Class<?>[] paramTypes;
    private final Object[] arguments;

    public CallMetadata(String methodName, Class<?>[] paramTypes, Object[] arguments) {
        this.methodName = methodName;
        this.paramTypes = paramTypes;
        this.arguments = arguments;
    }

    public String getMethodName() {
        return methodName;
    }

    public Class<?>[] getParamTypes() {
        return paramTypes;
    }

    public Object[] getArguments() {
        return arguments;
    }
}
