/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.service;

import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.cxf.Bus;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.kuali.rice.core.api.exception.RiceRemoteServiceConnectionException;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.ksb.messaging.bam.service.BAMService;
import org.kuali.rice.ksb.messaging.exceptionhandling.ExceptionRoutingService;
import org.kuali.rice.ksb.messaging.service.MessageQueueService;
import org.kuali.rice.ksb.messaging.serviceexporters.ServiceExportManager;
import org.kuali.rice.ksb.messaging.threadpool.KSBScheduledPool;
import org.kuali.rice.ksb.messaging.threadpool.KSBThreadPool;
import org.kuali.rice.ksb.security.admin.service.JavaSecurityManagementService;
import org.kuali.rice.ksb.security.service.DigitalSignatureService;
import org.kuali.rice.ksb.service.BasicAuthenticationService;
import org.quartz.Scheduler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class KSBServiceLocator {
    public static Object getService(String name) {
        return GlobalResourceLoader.getService((String)name);
    }

    public static EntityManagerFactory getMessageEntityManagerFactory() {
        return (EntityManagerFactory)KSBServiceLocator.getService("rice.ksb.messageEntityManagerFactory");
    }

    public static EntityManagerFactory getRegistryEntityManagerFactory() {
        return (EntityManagerFactory)KSBServiceLocator.getService("rice.ksb.registryEntityManagerFactory");
    }

    public static TransactionTemplate getTransactionTemplate() {
        return (TransactionTemplate)KSBServiceLocator.getService("transactionTemplate");
    }

    public static PlatformTransactionManager getPlatformTransactionManager() {
        return (PlatformTransactionManager)KSBServiceLocator.getService("transactionManager");
    }

    public static BAMService getBAMService() {
        return (BAMService)KSBServiceLocator.getService("rice.ksb.bamService");
    }

    public static MessageQueueService getMessageQueueService() {
        return (MessageQueueService)KSBServiceLocator.getService("rice.ksb.messageQueueService");
    }

    public static ExceptionRoutingService getExceptionRoutingService() {
        return (ExceptionRoutingService)KSBServiceLocator.getService("rice.ksb.exceptionMessagingService");
    }

    public static ServiceExportManager getServiceExportManager() {
        return (ServiceExportManager)KSBServiceLocator.getService("rice.ksb.serviceExportManager");
    }

    public static DigitalSignatureService getDigitalSignatureService() {
        return (DigitalSignatureService)KSBServiceLocator.getService("rice.ksb.digitalSignatureService");
    }

    public static JavaSecurityManagementService getJavaSecurityManagementService() {
        return (JavaSecurityManagementService)KSBServiceLocator.getService("rice.ksb.javaSecurityManagementService");
    }

    public static KSBThreadPool getThreadPool() {
        return (KSBThreadPool)KSBServiceLocator.getService("rice.ksb.threadPool");
    }

    public static KSBScheduledPool getScheduledPool() {
        return (KSBScheduledPool)KSBServiceLocator.getService("rice.ksb.scheduledThreadPool");
    }

    public static Bus getCXFBus() {
        return (Bus)KSBServiceLocator.getService("cxf");
    }

    public static List<Interceptor<? extends Message>> getInInterceptors() {
        try {
            return (List)KSBServiceLocator.getService("ksbInInterceptors");
        }
        catch (RiceRemoteServiceConnectionException ex) {
            return null;
        }
    }

    public static List<Interceptor<? extends Message>> getOutInterceptors() {
        try {
            return (List)KSBServiceLocator.getService("ksbOutInterceptors");
        }
        catch (RiceRemoteServiceConnectionException ex) {
            return null;
        }
    }

    public static DataSource getMessageDataSource() {
        return (DataSource)KSBServiceLocator.getService("rice.ksb.messageDataSource");
    }

    public static DataSource getMessageNonTransactionalDataSource() {
        return (DataSource)KSBServiceLocator.getService("rice.ksb.messageNonTransactionalDataSource");
    }

    public static DataSource getRegistryDataSource() {
        return (DataSource)KSBServiceLocator.getService("rice.ksb.registryDataSource");
    }

    public static Scheduler getScheduler() {
        return (Scheduler)KSBServiceLocator.getService("rice.ksb.scheduler");
    }

    public static BasicAuthenticationService getBasicAuthenticationService() {
        return (BasicAuthenticationService)KSBServiceLocator.getService("basicAuthenticationService");
    }
}

