/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.security;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.Signature;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

import org.kuali.rice.ksb.service.KSBServiceLocator;

/**
 * An HttpServletResponseWrapper which wraps the underlying response's OutputStream in a 
 * SignatureSingingOutputStream which will generate a digital signature for the outgoing message.
 *  
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class SignatureSigningResponseWrapper extends HttpServletResponseWrapper {

	private DigitalSigner signer;
	private ServletOutputStream outputStream;
	private PrintWriter writer;
	
	public SignatureSigningResponseWrapper(HttpServletResponse response) {
		super(response);
		try {		
			Signature signature = KSBServiceLocator.getDigitalSignatureService().getSignatureForSigning();
			String alias = KSBServiceLocator.getJavaSecurityManagementService().getModuleKeyStoreAlias();	
			this.signer = new ResponseHeaderDigitalSigner(signature, alias, response);
		} catch (Exception e) {
			throw new RuntimeException("Failed to initialize digital signature verification.", e);
		}
	}

	@Override
	public ServletOutputStream getOutputStream() throws IOException {
		if (this.outputStream == null) {
		    this.outputStream = new SignatureSigningOutputStream(this.signer, super.getOutputStream(), true);
		}
		return this.outputStream;
	}

	@Override
	public PrintWriter getWriter() throws IOException {
		if (this.writer == null) {
		    this.writer =  new PrintWriter(getOutputStream());
		}
		return this.writer;
	}
	
}
