/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.security.soap;

import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerConstants;
import org.kuali.rice.core.api.security.credentials.Credentials;
import org.kuali.rice.core.api.security.credentials.CredentialsSource;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.security.credentials.UsernamePasswordCredentials;
import org.springframework.util.Assert;


/**
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @since 0.9
 * 
 */
public class CredentialsOutHandler extends WSS4JOutInterceptor {

	private final CredentialsSource credentialsSource;

	private final ServiceConfiguration serviceConfiguration;

	public CredentialsOutHandler(final CredentialsSource credentialsSource,
			final ServiceConfiguration serviceConfiguration) {
		Assert.notNull(credentialsSource, "credentialsSource cannot be null.");
		Assert.notNull(serviceConfiguration, "serviceConfiguration cannot be null.");
		this.credentialsSource = credentialsSource;
		this.serviceConfiguration = serviceConfiguration;

		final Credentials credentials = this.credentialsSource
				.getCredentials(this.serviceConfiguration.getEndpointUrl().toString());

		Assert.isTrue(credentials instanceof UsernamePasswordCredentials,
				"Credentials must be of type usernamepassword.");

		final UsernamePasswordCredentials c = (UsernamePasswordCredentials) credentials;
		setProperty(WSHandlerConstants.USER, c.getUsername());
	}

	public WSPasswordCallback getPassword(final String username,
			final int doAction, final String clsProp, final String refProp,
			final RequestData reqData) throws WSSecurityException {
		final UsernamePasswordCredentials c = (UsernamePasswordCredentials) this.credentialsSource
				.getCredentials(this.serviceConfiguration.getEndpointUrl().toString());

		return new WSPasswordCallback(c.getUsername(), c.getPassword(), null,
				WSPasswordCallback.USERNAME_TOKEN);
	}
}

