/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.serviceproxies;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.kuali.rice.ksb.messaging.MessageServiceInvoker;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.springframework.core.Ordered;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;

/**
 * Sends message when current transaction commits.  
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class MessageSendingTransactionSynchronization extends TransactionSynchronizationAdapter {
    
    private static final Logger LOG = LogManager.getLogger(MessageSendingTransactionSynchronization.class);

    private final PersistedMessageBO message;
    
    public MessageSendingTransactionSynchronization(PersistedMessageBO message) {
	    this.message = message;
    }

    @Override
    public void afterCompletion(int status) {
        if (status == STATUS_COMMITTED) {
            KSBServiceLocator.getThreadPool().execute(new MessageServiceInvoker(message));
        } else {
            LOG.warn("Message " + message + " not sent because transaction has a status of " + ((status == STATUS_ROLLED_BACK) ? "STATUS_ROLLED_BACK" : (status == STATUS_UNKNOWN) ? "STATUS_UNKNOWN" : Integer.valueOf(status).toString()));
        }
    }

    @Override
	public int getOrder() {
		return Ordered.HIGHEST_PRECEDENCE;
	}
}
