/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.service.impl;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.dao.MessageQueueDAO;
import org.kuali.rice.ksb.messaging.service.MessageQueueService;

public class MessageQueueServiceImpl
implements MessageQueueService {
    private static final Logger LOG = LogManager.getLogger(MessageQueueServiceImpl.class);
    private MessageQueueDAO messageQueueDao;

    @Override
    public void delete(PersistedMessageBO routeQueue) {
        if (Boolean.parseBoolean(ConfigContext.getCurrentContextConfig().getProperty("message.persistence"))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Message Persistence is on.  Deleting stored message" + String.valueOf(routeQueue));
            }
            this.getMessageQueueDao().remove(routeQueue);
        }
    }

    @Override
    public PersistedMessageBO save(PersistedMessageBO routeQueue) {
        if (Boolean.parseBoolean(ConfigContext.getCurrentContextConfig().getProperty("message.persistence"))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Persisting Message " + String.valueOf(routeQueue));
            }
            return this.getMessageQueueDao().save(routeQueue);
        }
        return routeQueue;
    }

    @Override
    public List<PersistedMessageBO> findAll(int maxRows) {
        return this.getMessageQueueDao().findAll(maxRows);
    }

    @Override
    public PersistedMessageBO findByRouteQueueId(Long routeQueueId) {
        return this.getMessageQueueDao().findByRouteQueueId(routeQueueId);
    }

    @Override
    public List<PersistedMessageBO> getNextDocuments(Integer maxDocuments) {
        return this.getMessageQueueDao().getNextDocuments(maxDocuments);
    }

    public MessageQueueDAO getMessageQueueDao() {
        return this.messageQueueDao;
    }

    public void setMessageQueueDao(MessageQueueDAO queueDAO) {
        this.messageQueueDao = queueDAO;
    }

    @Override
    public List<PersistedMessageBO> findByValues(Map<String, String> criteriaValues, int maxRows) {
        return this.getMessageQueueDao().findByValues(criteriaValues, maxRows);
    }
}

