/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.config.wss4j;

import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import java.io.IOException;


/**
 * Workflow CryptoPasswordCallbackHandler which retrieves the keystore password
 * from the workflow Config.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class CryptoPasswordCallbackHandler implements CallbackHandler {

    /**
     * The actual CallBackHandler implementation.
     */
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; i++) {
            if (callbacks[i] instanceof WSPasswordCallback) {
                WSPasswordCallback pc = (WSPasswordCallback) callbacks[i];
                String password = ConfigContext.getCurrentContextConfig().getKeystorePassword();
                if (password == null) {
                	throw new ConfigurationException("Could not locate the webservice password.  Should be configured as the '" + Config.KEYSTORE_PASSWORD + "' property.");
                }
                pc.setPassword(password);
            } else {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }
}
