/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
package org.kuali.rice.ksb.messaging;

import javax.persistence.*;
import java.io.Serializable;

@Entity
@Table(name="KRSB_MSG_PYLD_T")
public class PersistedMessagePayload implements Serializable {

    private static final long serialVersionUID = 508778527504899029L;

    @Id
    @OneToOne(cascade = { CascadeType.REFRESH })
    @JoinColumn(name = "MSG_QUE_ID", referencedColumnName = "MSG_QUE_ID", nullable = false, updatable = false)
    private PersistedMessageBO persistedMessage;

    @Lob
	@Basic(fetch= FetchType.LAZY)
	@Column(name="MSG_PYLD", length=4000)
	private String payload;

    public String getPayload() {
        return this.payload;
    }
    public void setPayload(String payload) {
        this.payload = payload;
    }

    public PersistedMessageBO getPersistedMessage() {
        return persistedMessage;
    }

    public void setPersistedMessage(PersistedMessageBO persistedMessage) {
        this.persistedMessage = persistedMessage;
    }
}
