/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging;

import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.api.util.ContextClassLoaderProxy;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.messaging.bam.BAMServerProxy;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;
import org.springframework.remoting.support.RemoteInvocationTraceInterceptor;

import java.util.Arrays;
import java.util.List;


public class KSBHttpInvokerServiceExporter extends HttpInvokerServiceExporter {
	
	private List<Class<?>> serviceInterfaces;
	private ServiceDefinition serviceDefinition;
	private boolean registerTraceInterceptor = true;
	
	public ServiceDefinition getServiceDefinition() {
		return this.serviceDefinition;
	}

	public void setServiceDefinition(ServiceDefinition serviceDefinition) {
		this.serviceDefinition = serviceDefinition;
	}
	
	/**
	 * @see org.springframework.remoting.support.RemoteExporter#setRegisterTraceInterceptor(boolean)
	 */
	@Override
	public void setRegisterTraceInterceptor(boolean registerTraceInterceptor) {
	    // HttpInvokerServiceExporter.registerTraceInterceptor is no longer exposed, capture its value if set
	    this.registerTraceInterceptor = registerTraceInterceptor;
	    super.setRegisterTraceInterceptor(registerTraceInterceptor);
	}

	@Override
    protected Object getProxyForService() {
		checkService();
		checkServiceInterface();
		ProxyFactory proxyFactory = new ProxyFactory();
		for (Class<?> serviceInterface : getServiceInterfaces()) {
			proxyFactory.addInterface(serviceInterface);
		}
		if (registerTraceInterceptor == true) {
			proxyFactory.addAdvice(new RemoteInvocationTraceInterceptor(getExporterName()));
		}
		ClassLoader classLoader = serviceDefinition.getServiceClassLoader();
		if (classLoader == null) {
		    classLoader = ClassLoaderUtils.getDefaultClassLoader();
		}
		Object service = ContextClassLoaderProxy.wrap(getService(), classLoader);
		service = BAMServerProxy.wrap(service, getServiceDefinition());
		proxyFactory.setTarget(service);
		return proxyFactory.getProxy(classLoader);
	}

	@Override
	protected void checkServiceInterface() throws IllegalArgumentException {
		if (this.serviceInterfaces == null) {
		    this.serviceInterfaces = Arrays.asList(ContextClassLoaderProxy.getInterfacesToProxy(getService()));
		}
		if (getServiceInterfaces().isEmpty()) {
			throw new IllegalArgumentException("At least one service interface should be defined.");
		}
	}
	
	public List<Class<?>> getServiceInterfaces() {
		return this.serviceInterfaces;
	}

	public void setServiceInterfaces(List<Class<?>> serviceInterfaces) {
		this.serviceInterfaces = serviceInterfaces;
	}
	
	@Override
    public Object getService() {
		return super.getService();
	}
	
}
