/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging;

import org.kuali.rice.ksb.api.messaging.AsynchronousCall;

import java.io.Serializable;
import java.sql.Timestamp;

public interface PersistedMessage extends Serializable {
    String getApplicationId();

    String getIpNumber();

    Timestamp getQueueDate();

    Integer getQueuePriority();

    String getQueueStatus();

    Integer getRetryCount();

    Long getRouteQueueId();

    String getServiceName();

    String getMethodName();

    Timestamp getExpirationDate();

    String getValue1();

    String getValue2();

    String getPayload();

    AsynchronousCall getMethodCall();
}
