/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.exceptionhandling;

import org.kuali.rice.ksb.messaging.PersistedMessageBO;

/**
 * A MessageExceptionHandler handles exception which arrise during processing of the
 * message.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface MessageExceptionHandler {

	void handleException(Throwable throwable, PersistedMessageBO message) throws Exception;
	
	void handleExceptionLastDitchEffort(Throwable throwable, PersistedMessageBO message) throws Exception;
	
    /**
     * Determines whether the message would go into Exception if submitted.
     * @param message The PersistedMessageBO instance to be tested.
     * @return Returns true if the message would go into exception, otherwise returns false.
     */
    boolean isInException(PersistedMessageBO message);

}
