/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.servicehandlers;

import org.apache.wss4j.common.ext.WSPasswordCallback;

import java.io.IOException;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;


/**
 * CallbackHandler that sets the password if the callback is an instance of WSPasswordCallback
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */

public class BasicAuthenticationPasswordHandler implements CallbackHandler {

    private String password;

    /**
     * Initialize the BasicAuthenticationPasswordHandler with the password
     *
     * @param password the password to use
     */
    public BasicAuthenticationPasswordHandler(String password) {
        this.password = password;
    }

    /**
     * @param callbacks an array of Callback objects
     * @see javax.security.auth.callback.CallbackHandler#handle(javax.security.auth.callback.Callback[]
     */
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks[0] != null && callbacks[0] instanceof WSPasswordCallback) {
            WSPasswordCallback pc = (WSPasswordCallback) callbacks[0];
            pc.setPassword(password);
        }
    }
}
