/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.impl.registry;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.kuali.rice.ksb.api.registry.ServiceEndpointStatus;
import org.kuali.rice.ksb.impl.registry.ServiceDescriptorBo;
import org.kuali.rice.ksb.impl.registry.ServiceInfoBo;
import org.kuali.rice.ksb.impl.registry.ServiceRegistryDao;
import org.springmodules.orm.ojb.PersistenceBrokerCallback;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class ServiceRegistryDaoOjb
extends PersistenceBrokerDaoSupport
implements ServiceRegistryDao {
    private static final String UPDATE_STATUS_FOR_INSTANCE_ID = "update KRSB_SVC_DEF_T set STAT_CD=? where INSTN_ID=?";

    @Override
    public ServiceInfoBo getServiceInfo(String serviceId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("serviceId", (Object)serviceId);
        return (ServiceInfoBo)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(ServiceInfoBo.class, crit));
    }

    @Override
    public List<ServiceInfoBo> getOnlineServiceInfosByName(QName serviceName) {
        Criteria crit = new Criteria();
        crit.addEqualTo("serviceName", (Object)serviceName.toString());
        crit.addEqualTo("statusCode", (Object)ServiceEndpointStatus.ONLINE.getCode());
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ServiceInfoBo.class, crit));
    }

    @Override
    public List<ServiceInfoBo> getAllOnlineServiceInfos() {
        Criteria crit = new Criteria();
        crit.addEqualTo("statusCode", (Object)ServiceEndpointStatus.ONLINE.getCode());
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ServiceInfoBo.class, crit));
    }

    @Override
    public List<ServiceInfoBo> getAllServiceInfos() {
        Criteria crit = new Criteria();
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ServiceInfoBo.class, crit));
    }

    @Override
    public List<ServiceInfoBo> getAllServiceInfosForInstance(String instanceId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("instanceId", (Object)instanceId);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ServiceInfoBo.class, crit));
    }

    @Override
    public List<ServiceInfoBo> getAllServiceInfosForApplication(String applicationId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("applicationId", (Object)applicationId);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ServiceInfoBo.class, crit));
    }

    @Override
    public ServiceDescriptorBo getServiceDescriptor(String serviceDescriptorId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("id", (Object)serviceDescriptorId);
        return (ServiceDescriptorBo)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(ServiceDescriptorBo.class, crit));
    }

    @Override
    public ServiceDescriptorBo saveServiceDescriptor(ServiceDescriptorBo serviceDescriptor) {
        this.getPersistenceBrokerTemplate().store((Object)serviceDescriptor);
        return serviceDescriptor;
    }

    @Override
    public ServiceInfoBo saveServiceInfo(ServiceInfoBo serviceInfo) {
        this.getPersistenceBrokerTemplate().store((Object)serviceInfo);
        return serviceInfo;
    }

    @Override
    public void removeServiceInfo(String serviceId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("serviceId", (Object)serviceId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)new QueryByCriteria(ServiceInfoBo.class, crit));
    }

    @Override
    public void removeServiceDescriptor(String serviceDescriptorId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("id", (Object)serviceDescriptorId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)new QueryByCriteria(ServiceDescriptorBo.class, crit));
    }

    @Override
    public boolean updateStatus(String serviceId, String statusCode) {
        ServiceInfoBo serviceInfoBo = this.getServiceInfo(serviceId);
        if (serviceInfoBo == null) {
            return false;
        }
        serviceInfoBo.setStatusCode(statusCode);
        this.saveServiceInfo(serviceInfoBo);
        return true;
    }

    @Override
    public void updateStatusForInstanceId(final String instanceId, final String statusCode) {
        this.getPersistenceBrokerTemplate().execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker broker) {
                Statement preparedStatement = null;
                try {
                    Connection connection = broker.serviceConnectionManager().getConnection();
                    preparedStatement = connection.prepareStatement(ServiceRegistryDaoOjb.UPDATE_STATUS_FOR_INSTANCE_ID);
                    preparedStatement.setString(1, statusCode);
                    preparedStatement.setString(2, instanceId);
                    preparedStatement.executeUpdate();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to update status for instance id", e);
                }
                finally {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (SQLException e) {}
                    }
                }
                return null;
            }
        });
    }
}

